<?php include('./constant/layout/head.php'); ?>
<?php include('./constant/layout/header.php'); ?>
<?php include('./constant/layout/sidebar.php'); ?>
<?php include('./constant/connect.php'); ?>

<div class="page-wrapper" style="background-color: #f7f9fc; min-height: 100vh; padding: 20px;">

    <div class="row page-titles mb-4">
        <div class="col-md-5 align-self-center">
            <h3 class="text-primary" style="font-weight: 600; color: #4a6cf7;">Stock Management</h3>
        </div>
        <div class="col-md-7 align-self-center">
            <ol class="breadcrumb" style="background: transparent; padding: 0;">
                <li class="breadcrumb-item"><a href="javascript:void(0)" style="color:#888;">Home</a></li>
                <li class="breadcrumb-item active" style="color:#4a6cf7;">Stock Management</li>
            </ol>
        </div>
    </div>

    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-12 mx-auto">
                <div class="card" style="border-radius: 15px; box-shadow: 6px 6px 12px #d1d9e6, -6px -6px 12px #ffffff;">
                    <div class="card-body">
                        <form class="row" method="POST" id="submitStockForm" action="php_action/createStock.php" enctype="multipart/form-data">
                            <input type="hidden" name="currnt_date" class="form-control">
                            
                            <!-- Hidden field for total quantity -->
                            <input type="hidden" id="quantity" name="quantity" value="1">
                            
                            <!-- Row 1: Supplier and Medicine Selection -->
                            <div class="form-group col-md-6">
                                <label class="control-label">Supplier Name <span class="text-danger">*</span></label>
                                <select class="form-control soft-input" id="supplierName" name="supplierName" required style="height:50px">
                                    <option value="">~~SELECT~~</option>
                                    <?php 
                                    $sql = "SELECT supplier_id, supplier_name FROM suppliers WHERE supplier_status = 1 AND supplier_active = 1";
                                    $result = $connect->query($sql);
                                    while($row = $result->fetch_array()) {
                                        echo "<option value='".$row[0]."'>".$row[1]."</option>";
                                    } 
                                    ?>
                                </select>
                            </div>

                            <div class="form-group col-md-6">
                                <label class="control-label">Select Medicine <span class="text-danger">*</span></label>
                                <select class="form-control soft-input select2-medicine" id="medicineName" name="medicineName" required style="height:50px">
                                    <option value="">~~SELECT~~</option>
                                    <?php 
                                    $sql = "
                                        SELECT p.product_id, p.product_name, c.categories_name 
                                        FROM product p 
                                        INNER JOIN categories c ON p.categories_id = c.categories_id 
                                        WHERE p.status = 1
                                    ";
                                    $result = $connect->query($sql);
                                    while($row = $result->fetch_assoc()) {
                                        echo "<option value='".$row['product_id']."'>".$row['product_name']." - ".$row['categories_name']."</option>";
                                    } 
                                    ?>
                                </select>
                            </div>
  <div class="form-group col-md-3">
                                <label class="control-label">Unit Type <span class="text-danger">*</span></label>
                                <select class="form-control soft-input" id="unitType" name="unitType" required style="height:50px" onchange="generateUnitDescription()">
                                    <option value="pcs">Pieces</option>
                                    <option value="strips">Strips</option>
                                    <option value="bottles">Bottles</option>
                                    <option value="boxes">Boxes</option>
                                    <option value="tubes">Tubes</option>
                                    <option value="packs">Packs</option>
                                    <option value="jars">Jars</option>
                                    <option value="units">Units</option>
                                    <option value="tablets">Tablets</option>
                                    <option value="capsules">Capsules</option>
                                    <option value="vials">Vials</option>
                                    <option value="ampoules">Ampoules</option>
                                    <option value="sachets">Sachets</option>
                                </select>
                            </div>
                            <!-- Row 2: Unit Configuration -->
                            <div class="form-group col-md-3">
                                <label class="control-label">Number of Units/Packs <span class="text-danger">*</span></label>
                                <input type="number" class="form-control soft-input" id="numberOfUnits" placeholder="Number of units" name="numberOfUnits" value="1" min="1" required autocomplete="off" oninput="calculateTotalQuantity()">
                            </div>

                          

                            <div class="form-group col-md-3">
                                <label class="control-label">Items per Unit <span class="text-danger">*</span></label>
                                <input type="number" class="form-control soft-input" id="itemsPerUnit" placeholder="Items per unit" name="itemsPerUnit" value="1" min="1" required autocomplete="off" oninput="calculateTotalQuantity(); generateUnitDescription()">
                            </div>

                            <div class="form-group col-md-3">
                                <label class="control-label">Unit Description</label>
                                <input type="text" class="form-control soft-input" id="unitDescription" placeholder="e.g., Strip of 10 tablets" name="unitDescription" autocomplete="off" readonly>
                            </div>

                            <!-- Row 3: Total Quantity Display -->
                            <div class="col-md-12 mb-3">
                                <div class="alert alert-info">
                                    <strong>Total Quantity: <span id="totalQuantityDisplay">1</span> items</strong>
                                    <small class="text-muted">(Number of Units × Items per Unit)</small>
                                    <input type="hidden" id="calculatedQuantity" name="calculatedQuantity" value="1">
                                </div>
                            </div>

                            <!-- Row 4: Pack Purchase Rates -->
                            <div class="form-group col-md-3">
                                <label class="control-label">Pack Purchase Rate <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <span class="input-group-text">₹</span>
                                    <input type="number" class="form-control soft-input" id="packPurchaseRate" placeholder="Pack purchase rate" name="packPurchaseRate" value="0" step="0.01" min="0" required autocomplete="off" oninput="calculatePerItemPrices()">
                                </div>
                            </div>

                            <div class="form-group col-md-3">
                                <label class="control-label">Per Item Purchase <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <span class="input-group-text">₹</span>
                                    <input type="number" class="form-control soft-input" id="perItemPurchaseInput" placeholder="Per item purchase" value="0" step="0.01" min="0" required autocomplete="off" oninput="calculatePackPricesFromPerItem('purchase')">
                                </div>
                            </div>

                            <div class="form-group col-md-3">
                                <label class="control-label">&nbsp;</label>
                                <button type="button" class="btn btn-outline-primary btn-block" onclick="calculatePerItemPrices()" style="height: 46px; margin-top: 8px;">
                                    <i class="fas fa-sync-alt"></i> Sync Prices
                                </button>
                            </div>

                            <div class="form-group col-md-3">
                                <label class="control-label">Auto Calculate</label>
                                <div class="form-check mt-2">
                                    <input class="form-check-input" type="checkbox" id="autoCalculate" checked>
                                    <label class="form-check-label" for="autoCalculate">
                                        Enable auto calculation
                                    </label>
                                </div>
                            </div>

                            <!-- Row 5: Pack Selling Rates -->
                            <div class="form-group col-md-3">
                                <label class="control-label">Pack Selling Rate <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <span class="input-group-text">₹</span>
                                    <input type="number" class="form-control soft-input" id="packSellingRate" placeholder="Pack selling rate" name="packSellingRate" value="0" step="0.01" min="0" required autocomplete="off" oninput="calculatePerItemPrices()">
                                </div>
                            </div>

                            <div class="form-group col-md-3">
                                <label class="control-label">Per Item Selling <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <span class="input-group-text">₹</span>
                                    <input type="number" class="form-control soft-input" id="perItemSellingInput" placeholder="Per item selling" value="0" step="0.01" min="0" required autocomplete="off" oninput="calculatePackPricesFromPerItem('selling')">
                                </div>
                            </div>

                            <!-- Row 6: Pack MRP Rates -->
                            <div class="form-group col-md-3">
                                <label class="control-label">Pack MRP <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <span class="input-group-text">₹</span>
                                    <input type="number" class="form-control soft-input" id="packMRP" placeholder="Pack MRP" name="packMRP" value="0" step="0.01" min="0" required autocomplete="off" oninput="calculatePerItemPrices()">
                                </div>
                            </div>

                            <div class="form-group col-md-3">
                                <label class="control-label">Per Item MRP <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <span class="input-group-text">₹</span>
                                    <input type="number" class="form-control soft-input" id="perItemMRPInput" placeholder="Per item MRP" value="0" step="0.01" min="0" required autocomplete="off" oninput="calculatePackPricesFromPerItem('mrp')">
                                </div>
                            </div>

                            <!-- Hidden fields for individual item prices -->
                            <input type="hidden" id="purchaseRate" name="purchaseRate" value="0">
                            <input type="hidden" id="rate" name="rate" value="0">
                            <input type="hidden" id="mrp" name="mrp" value="0">

                            <!-- Row 7: Tax Information -->
                            <div class="form-group col-md-3">
                                <label class="control-label">SGST % <span class="text-danger">*</span></label>
                                <input type="number" class="form-control soft-input" id="sgst" placeholder="SGST %" name="sgst" step="0.01" min="0" value="0" required autocomplete="off">
                            </div>
                            
                            <div class="form-group col-md-3">
                                <label class="control-label">CGST % <span class="text-danger">*</span></label>
                                <input type="number" class="form-control soft-input" id="cgst" placeholder="CGST %" name="cgst" step="0.01" min="0" value="0" required autocomplete="off">
                            </div>

                            <div class="form-group col-md-3">
                                <label class="control-label">Batch No <span class="text-muted">(Optional)</span></label>
                                <input type="text" class="form-control soft-input" id="bno" placeholder="Batch No" name="bno" value="ABC123" pattern="^[a-zA-Z0-9]+$" autocomplete="off">
                            </div>

                            <div class="form-group col-md-3">
                                <label class="control-label">Expiry Date <span class="text-danger">*</span></label>
                                <input type="date" class="form-control soft-input" id="expdate" name="expdate" required>
                            </div>

                            <!-- Row 8: Chamber and Submit Button -->
                            <div class="form-group col-md-6">
                                <label class="control-label">Chamber <span class="text-muted">(Optional)</span></label>
                                <select class="form-control soft-input select2-chamber" id="chamber" name="chamber" style="height:50px">
                                    <option value="">~~SELECT~~</option>
                                    <?php
                                    $chamber_sql = "SELECT id, chamber_name, column_number, row_no 
                                                    FROM chambers 
                                                    WHERE deleted = 0 
                                                    ORDER BY chamber_name";
                                    $chamber_result = $connect->query($chamber_sql);

                                    if ($chamber_result && $chamber_result->num_rows > 0) {
                                        while ($chamber_row = $chamber_result->fetch_assoc()) {
                                            $display_text = $chamber_row['chamber_name'];
                                            if (!empty($chamber_row['column_number']) || !empty($chamber_row['row_no'])) {
                                                $display_text .= " (Col: " . $chamber_row['column_number'] . ", Row: " . $chamber_row['row_no'] . ")";
                                            }
                                            $data_location = "Column: " . $chamber_row['column_number'] . " | Row: " . $chamber_row['row_no'];
                                            echo "<option value='" . $chamber_row['id'] . "' data-location='" . $data_location . "'>" . $display_text . "</option>";
                                        }
                                    } else {
                                        echo "<option value='main' data-location='Main Building'>Main Chamber</option>
                                              <option value='storage' data-location='Storage Area'>Storage Room</option>
                                              <option value='refrigerated' data-location='Cold Storage'>Refrigerated Chamber</option>
                                              <option value='quarantine' data-location='Isolation Area'>Quarantine Area</option>";
                                    }
                                    ?>
                                </select>
                            </div>

                            <div class="form-group col-md-6 d-flex align-items-end">
                                <button type="submit" name="create" id="createStockBtn" class="btn btn-primary soft-btn w-100" style="height: 50px;">
                                    <i class="fas fa-plus-circle"></i> Add Stock
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.soft-input {
    border-radius: 12px;
    border: 1px solid #d1d9e6;
    padding: 10px 12px;
    box-shadow: inset 3px 3px 6px #d1d9e6, inset -3px -3px 6px #ffffff;
    transition: all 0.3s ease;
}

.soft-input:focus {
    border-color: #4a6cf7;
    box-shadow: inset 2px 2px 5px #c1c7d0, inset -2px -2px 5px #ffffff;
    outline: none;
}

.soft-btn {
    padding: 10px 20px;
    border-radius: 12px;
    box-shadow: 4px 4px 12px #d1d9e6, -4px -4px 12px #ffffff;
    transition: all 0.3s ease;
    font-weight: 500;
}

.soft-btn:hover {
    transform: translateY(-2px);
    box-shadow: 2px 2px 8px #c1c7d0, -2px -2px 8px #ffffff;
}

.input-group-text {
    background-color: #f8f9fa;
    border: 1px solid #d1d9e6;
    border-radius: 12px 0 0 12px !important;
}

.alert-info {
    border-radius: 8px;
    margin-bottom: 0;
}

/* Select2 styling */
.select2-container--default .select2-selection--single {
    height: 50px !important;
    padding: 10px 12px !important;
    display: flex !important;
    align-items: center !important;
    border-radius: 12px;
    border: 1px solid #d1d9e6;
}

.select2-container--default .select2-selection--single .select2-selection__arrow {
    height: 48px !important;
}

.select2-dropdown {
    border-radius: 12px;
    border: 1px solid #d1d9e6;
}

.form-group {
    margin-bottom: 1.5rem;
}

.form-check {
    margin-top: 10px;
}

.form-check-input {
    margin-right: 8px;
}

.price-group {
    background: #f8f9fa;
    padding: 15px;
    border-radius: 12px;
    margin-bottom: 15px;
}
</style>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

<script>
$(document).ready(function() {
    // Initialize Select2
    $('.select2-medicine').select2({
        placeholder: "Type to search medicines...",
        allowClear: true,
        width: '100%'
    });
    
    $('.select2-chamber').select2({
        placeholder: "Type to search chambers...",
        allowClear: true,
        width: '100%'
    });

    // Set default expiry date to 1 year from now
    const nextYear = new Date();
    nextYear.setFullYear(nextYear.getFullYear() + 1);
    $('#expdate').val(nextYear.toISOString().split('T')[0]);
    
    // Initialize calculations on page load
    calculateTotalQuantity();
    calculatePerItemPrices();
    generateUnitDescription();
});

// Function to calculate total quantity
function calculateTotalQuantity() {
    const numberOfUnits = parseInt($('#numberOfUnits').val()) || 0;
    const itemsPerUnit = parseInt($('#itemsPerUnit').val()) || 0;
    const totalQuantity = numberOfUnits * itemsPerUnit;
    
    // Update display
    $('#totalQuantityDisplay').text(totalQuantity);
    $('#calculatedQuantity').val(totalQuantity);
    
    // Update the hidden quantity field for form submission
    $('#quantity').val(totalQuantity);
    
    // Recalculate prices since total quantity changed
    if ($('#autoCalculate').is(':checked')) {
        calculatePerItemPrices();
    }
}

// Function to calculate per item prices from pack prices
function calculatePerItemPrices() {
    if (!$('#autoCalculate').is(':checked')) return;
    
    const numberOfUnits = parseInt($('#numberOfUnits').val()) || 1;
    const itemsPerUnit = parseInt($('#itemsPerUnit').val()) || 1;
    const totalItems = numberOfUnits * itemsPerUnit;
    
    const packPurchaseRate = parseFloat($('#packPurchaseRate').val()) || 0;
    const packSellingRate = parseFloat($('#packSellingRate').val()) || 0;
    const packMRP = parseFloat($('#packMRP').val()) || 0;
    
    // Calculate per item prices
    const perItemPurchase = totalItems > 0 ? (packPurchaseRate / totalItems) : 0;
    const perItemSelling = totalItems > 0 ? (packSellingRate / totalItems) : 0;
    const perItemMRP = totalItems > 0 ? (packMRP / totalItems) : 0;
    
    // Update per item input fields
    $('#perItemPurchaseInput').val(perItemPurchase.toFixed(2));
    $('#perItemSellingInput').val(perItemSelling.toFixed(2));
    $('#perItemMRPInput').val(perItemMRP.toFixed(2));
    
    // Update hidden fields for form submission
    $('#purchaseRate').val(perItemPurchase.toFixed(2));
    $('#rate').val(perItemSelling.toFixed(2));
    $('#mrp').val(perItemMRP.toFixed(2));
}

// Function to calculate pack prices from per item prices
function calculatePackPricesFromPerItem(type) {
    if (!$('#autoCalculate').is(':checked')) return;
    
    const numberOfUnits = parseInt($('#numberOfUnits').val()) || 1;
    const itemsPerUnit = parseInt($('#itemsPerUnit').val()) || 1;
    const totalItems = numberOfUnits * itemsPerUnit;
    
    switch(type) {
        case 'purchase':
            const perItemPurchase = parseFloat($('#perItemPurchaseInput').val()) || 0;
            const packPurchaseRate = perItemPurchase * totalItems;
            $('#packPurchaseRate').val(packPurchaseRate.toFixed(2));
            break;
            
        case 'selling':
            const perItemSelling = parseFloat($('#perItemSellingInput').val()) || 0;
            const packSellingRate = perItemSelling * totalItems;
            $('#packSellingRate').val(packSellingRate.toFixed(2));
            break;
            
        case 'mrp':
            const perItemMRP = parseFloat($('#perItemMRPInput').val()) || 0;
            const packMRP = perItemMRP * totalItems;
            $('#packMRP').val(packMRP.toFixed(2));
            break;
    }
    
    // Update hidden fields
    $('#purchaseRate').val($('#perItemPurchaseInput').val());
    $('#rate').val($('#perItemSellingInput').val());
    $('#mrp').val($('#perItemMRPInput').val());
}

// Function to generate unit description automatically
function generateUnitDescription() {
    const unitType = $('#unitType option:selected').text();
    const itemsPerUnit = $('#itemsPerUnit').val();
    
    if (itemsPerUnit > 1) {
        $('#unitDescription').val(unitType + ' of ' + itemsPerUnit + ' items');
    } else {
        $('#unitDescription').val(unitType);
    }
}

// Toggle auto calculation
$('#autoCalculate').change(function() {
    if ($(this).is(':checked')) {
        calculatePerItemPrices();
    }
});

// Form validation before submission
$('#submitStockForm').on('submit', function(e) {
    const totalQuantity = parseInt($('#quantity').val()) || 0;
    
    if (totalQuantity <= 0) {
        e.preventDefault();
        alert('Please enter valid quantity values. Total quantity must be greater than 0.');
        return false;
    }
    
    // Validate that prices are reasonable
    const packPurchaseRate = parseFloat($('#packPurchaseRate').val()) || 0;
    const packSellingRate = parseFloat($('#packSellingRate').val()) || 0;
    const packMRP = parseFloat($('#packMRP').val()) || 0;
    
    const perItemPurchase = parseFloat($('#perItemPurchaseInput').val()) || 0;
    const perItemSelling = parseFloat($('#perItemSellingInput').val()) || 0;
    const perItemMRP = parseFloat($('#perItemMRPInput').val()) || 0;
    
    if (packPurchaseRate <= 0 || packSellingRate <= 0 || packMRP <= 0 ||
        perItemPurchase <= 0 || perItemSelling <= 0 || perItemMRP <= 0) {
        e.preventDefault();
        alert('Please enter valid price values. All prices must be greater than 0.');
        return false;
    }
    
    if (packSellingRate > packMRP || perItemSelling > perItemMRP) {
        e.preventDefault();
        alert('Selling rate cannot be higher than MRP.');
        return false;
    }
    
    if (packPurchaseRate > packSellingRate || perItemPurchase > perItemSelling) {
        e.preventDefault();
        alert('Purchase rate cannot be higher than selling rate.');
        return false;
    }
    
    return true;
});
</script>

<?php include('./constant/layout/footer.php'); ?>