<?php include('./constant/layout/head.php'); ?>
<?php include('./constant/layout/header.php'); ?>
<?php include('./constant/layout/sidebar.php'); ?>
<?php include('./constant/connect.php');

$sql = "SELECT brand_id, brand_name, brand_active, brand_status FROM brands WHERE brand_status = 1";
$result = $connect->query($sql);
?>

<div class="page-wrapper" style="background-color: #f7f9fc; min-height: 100vh; padding: 20px;">
    <div class="row page-titles mb-4">
        <div class="col-md-5 align-self-center">
            <h3 class="text-primary" style="font-weight: 600; color: #4a6cf7;">View Manufacturer</h3>
        </div>
        <div class="col-md-7 align-self-center">
            <ol class="breadcrumb" style="background: transparent; padding: 0;">
                <li class="breadcrumb-item"><a href="javascript:void(0)" style="color:#888;">Home</a></li>
                <li class="breadcrumb-item active" style="color:#4a6cf7;">View Manufacturer</li>
            </ol>
        </div>
    </div>

    <div class="container-fluid">
        <div class="card" style="border-radius: 15px; box-shadow: 6px 6px 12px #d1d9e6, -6px -6px 12px #ffffff;">
            <div class="card-body">
                <a href="add-brand.php">
                    <button class="btn btn-primary mb-3 soft-btn">
                        Add Manufacturer
                    </button>
                </a>

                <div class="table-responsive m-t-20">
                    <table id="myTable" class="table table-bordered table-hover table-striped">
                        <thead class="table-dark text-white soft-table-header">
                            <tr>
                                <th class="text-center">#</th>
                                <th>Manufacturer Name</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($result as $row) { ?>
                            <tr>
                                <td class="text-center"><?php echo $row['brand_id']; ?></td>
                                <td><?php echo $row['brand_name']; ?></td>
                                <td>
                                    <?php if($row['brand_active']==1): ?>
                                        <span class="badge soft-badge bg-success">Available</span>
                                    <?php else: ?>
                                        <span class="badge soft-badge bg-danger">Not Available</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <a href="editbrand.php?id=<?php echo $row['brand_id']; ?>">
                                        <button type="button" class="btn btn-sm btn-primary soft-btn">
                                            <i class="fa fa-pencil"></i>
                                        </button>
                                    </a>
                                    <a href="php_action/removeBrand.php?id=<?php echo $row['brand_id']; ?>" onclick="return confirm('Are you sure to delete this record?')">
                                        <button type="button" class="btn btn-sm btn-danger soft-btn">
                                            <i class="fa fa-trash"></i>
                                        </button>
                                    </a>
                                </td>
                            </tr>
                            <?php } ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
/* ----------------- Soft Digital UI ----------------- */

/* Soft badges */
.soft-badge {
    display: inline-block;
    padding: 6px 14px;
    border-radius: 12px;
    font-weight: 500;
    font-size: 0.85rem;
    box-shadow: 3px 3px 6px #d1d9e6,
                -3px -3px 6px #ffffff;
    transition: all 0.3s ease;
}

.soft-badge.bg-success {
    background-color: #d4f5e9;
    color: #1abc9c;
}

.soft-badge.bg-danger {
    background-color: #ffd6d6;
    color: #e74c3c;
}

/* Soft buttons */
.soft-btn {
    padding: 6px 12px;
    border-radius: 12px;
    box-shadow: 4px 4px 12px #d1d9e6,
                -4px -4px 12px #ffffff;
    transition: all 0.3s ease;
    font-weight: 500;
}

.soft-btn:hover {
    transform: translateY(-2px);
    box-shadow: 2px 2px 8px #c1c7d0,
                -2px -2px 8px #ffffff;
}

/* Soft table header */
.soft-table-header {
    background-color: #4a6cf7 !important;
    color: #ffffff !important;
    border-radius: 15px;
}

/* Table hover */
.table-hover tbody tr:hover {
    background-color: #eef3fb;
    transition: background-color 0.3s ease;
}

/* Card */
.card {
    background: #f7f9fc;
}

/* Breadcrumb links */
.breadcrumb a {
    text-decoration: none;
    font-weight: 500;
}

/* Smooth font & general */
body, .page-wrapper {
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    color: #4a4a4a;
}
</style>

<?php include('./constant/layout/footer.php'); ?>
