<?php 
include('./constant/layout/head.php');
include('./constant/layout/header.php');
include('./constant/layout/sidebar.php');
include('./constant/connect.php'); 
?>
<div class="page-wrapper">
    <div class="row page-titles">
        <div class="col-md-5 align-self-center">
            <h3 class="text-primary">Chamber Management</h3>
        </div>
        <div class="col-md-7 align-self-center">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="#">Home</a></li>
                <li class="breadcrumb-item active">Chamber Management</li>
            </ol>
        </div>
    </div>

    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-12" >
                <div class="card">
                    <div class="card-title d-flex justify-content-between align-items-center">
                        <h4>Manage Chambers</h4>
                        <button type="button" class="btn btn-primary btn-add" onclick="openModal('addChamberModal')">
                            <i class="fa fa-plus"></i> Add New Chamber
                        </button>
                    </div>
                    <div id="add-chamber-messages"></div>
                    <div id="success-message" class="alert alert-success" style="display: none;">
                        <button type="button" class="close" onclick="this.parentElement.style.display='none';">&times;</button>
                        <strong><i class="glyphicon glyphicon-ok-sign"></i></strong> Operation completed successfully!
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table id="chamberTable" class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                      <th>Row </th>
                                        <th>Column </th>
                                        
                                        <th>Created At</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $sql = "SELECT * FROM chambers WHERE deleted = 0 ORDER BY id DESC";
                                    $result = $connect->query($sql);
                                    if ($result->num_rows > 0) {
                                        while($row = $result->fetch_assoc()) {
                                            echo '<tr>
                                                <td>'.$row["id"].'</td>
                                                <td>'.$row["row_no"].'</td>
                                                <td>'.$row["column_number"].'</td>
                                               
                                                <td>'.date('M j, Y', strtotime($row["created_at"])).'</td>
                                                <td>
                                                    <button type="button" class="btn btn-info btn-sm editBtn" data-id="'.$row["id"].'">
                                                        <i class="fa fa-pencil"></i> Edit
                                                    </button>
                                                    <button type="button" class="btn btn-danger btn-sm deleteBtn" data-id="'.$row["id"].'">
                                                        <i class="fa fa-trash"></i> Delete
                                                    </button>
                                                </td>
                                            </tr>';
                                        }
                                    } else {
                                        echo '<tr><td colspan="6" class="text-center">No chambers found</td></tr>';
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Add Chamber Modal -->
   <div class="modal fade" id="addChamberModal" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Add New Chamber</h5>
                    <button type="button" class="close text-white" onclick="closeModal('addChamberModal')">&times;</button>
                </div>
                <form id="addChamberForm" method="POST">
                    <div class="modal-body">
                        <div class="form-group">
                            <label>Row </label>
                            <input type="text" class="form-control soft-input" name="row_no" required>
                        </div>
                        <div class="form-group">
                            <label>Column </label>
                            <input type="text" class="form-control soft-input" name="column_number" required>
                        </div>
                      
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary">Save Chamber</button>
                        <button type="button" class="btn btn-secondary" onclick="closeModal('addChamberModal')" style="background-color:red">Cancel</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<!-- Edit Chamber Modal -->
<div class="modal fade" id="editChamberModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Edit Chamber</h5>
                <button type="button" class="close text-white" onclick="closeModal('editChamberModal')">&times;</button>
            </div>
            <form id="editChamberForm" method="POST">
                <div class="modal-body">
                    <input type="hidden" id="edit_id" name="id">
                   <div class="form-group">
                        <label>Row </label>
                        <input type="text" class="form-control soft-input" id="edit_row_no" name="row_no" required>
                    </div>
                    <div class="form-group">
                        <label>Column </label>
                        <input type="text" class="form-control soft-input" id="edit_column_number" name="column_number" required>
                    </div>
                   
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary mr-auto">Update Chamber</button>
                    <button type="button" class="btn btn-secondary" onclick="closeModal('editChamberModal')" style="background-color:red">Close</button>
                </div>
            </form>
        </div>
    </div>
</div>


<!-- Delete Confirmation Modal -->
<div class="modal fade" id="deleteChamberModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Confirm Delete</h5>
                <button type="button" class="close text-white" onclick="closeModal('deleteChamberModal')">&times;</button>
            </div>
            <div class="modal-body">
                <p>Are you sure you want to delete this chamber?</p>
                <input type="hidden" id="delete_id">
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" onclick="closeModal('deleteChamberModal')">Cancel</button>
                <button type="button" class="btn btn-danger" id="confirmDelete">Delete</button>
            </div>
        </div>
    </div>
</div>

<script>
function openModal(id){
    $('#'+id).modal('show');
}
function closeModal(id){
    $('#'+id).modal('hide');
}

$(document).ready(function() {
    $('#chamberTable').DataTable();

    if (sessionStorage.getItem('showSuccessMessage') === 'true') {
        $('#success-message').show();
        sessionStorage.removeItem('showSuccessMessage');
        setTimeout(()=>$('#success-message').fadeOut(),3000);
    }

    // ADD
    $('#addChamberForm').submit(function(e){
        e.preventDefault();
        $.post('createChamber.php', $(this).serialize(), function(response){
            if(response.success){
                closeModal('addChamberModal');
                sessionStorage.setItem('showSuccessMessage','true');
                location.reload();
            } else alert(response.message);
        },'json');
    });

    // EDIT
    $(document).on('click','.editBtn',function(){
        var id=$(this).data('id');
        $.post('getChamber.php',{id:id},function(res){
            if(res.success){
                $('#edit_id').val(res.data.id);
               
                $('#edit_column_number').val(res.data.column_number);
                $('#edit_row_no').val(res.data.row_no);
                openModal('editChamberModal');
            } else alert(res.message);
        },'json');
    });

    $('#editChamberForm').submit(function(e){
        e.preventDefault();
        $.post('updateChamber.php', $(this).serialize(), function(response){
            if(response.success){
                closeModal('editChamberModal');
                sessionStorage.setItem('showSuccessMessage','true');
                location.reload();
            } else alert(response.message);
        },'json');
    });

    // DELETE
    $(document).on('click','.deleteBtn',function(){
        $('#delete_id').val($(this).data('id'));
        openModal('deleteChamberModal');
    });

    $('#confirmDelete').click(function(){
        $.post('deleteChamber.php',{id:$('#delete_id').val()},function(response){
            if(response.success){
                closeModal('deleteChamberModal');
                sessionStorage.setItem('showSuccessMessage','true');
                location.reload();
            } else alert(response.message);
        },'json');
    });
});
</script>
<style> table.custom-table { width: 100%; border-collapse: collapse; margin: 20px 0; font-size: 15px; font-family: Arial, sans-serif; text-align: center; } table.custom-table th, table.custom-table td { border: 1px solid #ddd; padding: 10px; } table.custom-table thead { background-color: #2c3e50; color: #fff; } table.custom-table tbody tr:nth-child(even) { background-color: #f2f2f2; } table.custom-table tbody tr:hover { background-color: #d1ecf1; } .btn-sm { padding: 4px 8px; font-size: 12px; border: none; cursor: pointer; border-radius: 3px; } .btn-primary { background-color: #007bff; color: #fff; } .btn-danger { background-color: #dc3545; color: #fff; } </style> <style> /* --- Custom Table Styling --- */ #chamberTable { width: 100%; border-collapse: collapse; font-family: Arial, sans-serif; font-size: 14px; text-align: center; } #chamberTable thead th { background: linear-gradient(135deg, #667eea, #764ba2); color: #fff; padding: 12px 8px; text-transform: uppercase; border-bottom: 2px solid #ddd; } #chamberTable tbody td { padding: 10px; border: 1px solid #ddd; } #chamberTable tbody tr:nth-child(even) { background-color: #f9f9f9; } #chamberTable tbody tr:hover { background-color: #eef3ff; } /* Buttons inside the table */ #chamberTable .btn-sm { padding: 4px 8px; font-size: 12px; border-radius: 5px; } #chamberTable .btn-info { background: linear-gradient(135deg,#17a2b8,#39c0d6); border: none; color: #fff; } #chamberTable .btn-danger { background: linear-gradient(135deg,#dc3545,#f66); border: none; color: #fff; } table.dataTable thead th, table.dataTable thead td { background: linear-gradient(135deg, #667eea, #764ba2) !important; color: #fff !important; } /* D O P E S T Y L I N G */ body{background:#f5f7fa;font-family:'Segoe UI',sans-serif;color:#333;} .card{border-radius:15px;box-shadow:0 8px 25px rgba(0,0,0,.1);transition:.3s;} .card:hover{transform:translateY(-3px);} .table th{background:linear-gradient(135deg,#667eea,#764ba2);color:#fff;} .btn-primary{background:linear-gradient(135deg,#667eea,#764ba2);border:none;} .btn-primary:hover{background:linear-gradient(135deg,#556cd6,#643c9e);} .btn-info{background:linear-gradient(135deg,#17a2b8,#39c0d6);border:none;} .btn-danger{background:linear-gradient(135deg,#dc3545,#f66);} .btn-secondary{background:#6c757d;} .soft-input{border-radius:12px;padding:10px;} .modal-content{border-radius:15px;} .modal-header{background:linear-gradient(135deg,#667eea,#764ba2);color:#fff;} .close{text-shadow:none;} </style>
<!-- Popper (Bootstrap 4) -->
<script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.1/dist/umd/popper.min.js"></script>
<!-- Bootstrap JS -->
<script src="assets/js/lib/bootstrap/bootstrap.bundle.min.js"></script>

<?php include('./constant/layout/footer.php');?>

<style>
/* Keep your table + modal styles from before here */
</style>
