<?php
// constant/session_init.php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Load system settings into session if not already set
if (!isset($_SESSION['system_settings'])) {
    include('../constant/connect.php');
    
    $settings_query = $connect->query("SELECT system_name, title, email, logo FROM system_settings LIMIT 1");
    if ($settings_query && $settings_query->num_rows > 0) {
        $settings = $settings_query->fetch_assoc();
        $_SESSION['system_settings'] = $settings;
    } else {
        // Default values if no settings found
        $_SESSION['system_settings'] = [
            'system_name' => 'Pharmacy System',
            'title' => 'Pharmacy Management',
            'email' => 'admin@example.com',
            'logo' => ''
        ];
    }
}
?>