<?php //error_reporting(1); ?>
<?php include('./constant/layout/head.php');?>
<?php include('./constant/layout/header.php');?>
<?php include('./constant/layout/sidebar.php');?>

<?php 
// Existing queries
$lowStockSql = "SELECT * FROM product WHERE status = 1";
$lowStockQuery = $connect->query($lowStockSql);
$countLowStock = $lowStockQuery->num_rows;

$lowStockSql1 = "SELECT * FROM brands WHERE brand_status = 1";
$lowStockQuery1 = $connect->query($lowStockSql1);
$countLowStock1 = $lowStockQuery1->num_rows;

$date=date('Y-m-d');
$lowStockSql3 = "SELECT * FROM product WHERE expdate<'".$date."' AND status = 1";
$lowStockQuery3 = $connect->query($lowStockSql3);
$countLowStock3 = $lowStockQuery3->num_rows;

$lowStockSql2 = "SELECT * FROM orders WHERE delete_status =0";
$lowStockQuery2= $connect->query($lowStockSql2);
$countLowStock2 = $lowStockQuery2->num_rows;

// New queries for enhanced features
// Low stock alert (less than 20 items)
$lowStockAlertSql = "SELECT * FROM product WHERE quantity < 10 AND status = 1";
$lowStockAlertQuery = $connect->query($lowStockAlertSql);
$lowStockAlertCount = $lowStockAlertQuery->num_rows;

// Today's sales
$today = date('Y-m-d');
$todaySalesSql = "SELECT SUM(grandTotalValue) as total_sales FROM orders WHERE orderDate = '$today' AND delete_status = 0";
$todaySalesQuery = $connect->query($todaySalesSql);
$todaySales = $todaySalesQuery->fetch_assoc();
$todaySalesTotal = $todaySales['total_sales'] ? $todaySales['total_sales'] : 0;

// Monthly sales
$monthStart = date('Y-m-01');
$monthlySalesSql = "SELECT SUM(grandTotalValue) as total_sales FROM orders WHERE orderDate >= '$monthStart' AND delete_status = 0";
$monthlySalesQuery = $connect->query($monthlySalesSql);
$monthlySales = $monthlySalesQuery->fetch_assoc();
$monthlySalesTotal = $monthlySales['total_sales'] ? $monthlySales['total_sales'] : 0;

// Top selling products
$topProductsSql = "SELECT p.product_name, SUM(oi.quantity) as total_sold 
                   FROM order_item oi 
                   JOIN product p ON oi.productName = p.product_id 
                   GROUP BY oi.productName 
                   ORDER BY total_sold DESC 
                   LIMIT 5";
$topProductsQuery = $connect->query($topProductsSql);

// Recent transactions
$recentTransactionsSql = "SELECT o.uno, o.orderDate, o.clientName, o.grandTotalValue, o.paymentStatus 
                          FROM orders o 
                          WHERE o.delete_status = 0 
                          ORDER BY o.orderDate DESC 
                          LIMIT 5";
$recentTransactionsQuery = $connect->query($recentTransactionsSql);
?>

<style type="text/css">
    .ui-datepicker-calendar {
        display: none;
    }
    .dashboard-card {
        transition: transform 0.3s;
        border-radius: 10px;
        overflow: hidden;
        box-shadow: 0 4px 8px rgba(0,0,0,0.1);
        margin-bottom: 20px;
    }
    .dashboard-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 8px 16px rgba(0,0,0,0.2);
    }
    .stat-card {
        padding: 20px;
        color: white;
        border-radius: 10px;
    }
    .alert-badge {
        position: absolute;
        top: -10px;
        right: -10px;
        background: #ff4757;
        color: white;
        border-radius: 50%;
        width: 25px;
        height: 25px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 12px;
        font-weight: bold;
    }
    .quick-action-btn {
        background: #f1f2f6;
        border: none;
        border-radius: 10px;
        padding: 15px;
        text-align: center;
        transition: all 0.3s;
        margin-bottom: 15px;
    }
    .quick-action-btn:hover {
        background: #dfe4ea;
        transform: translateY(-3px);
    }
    .quick-action-btn i {
        font-size: 24px;
        margin-bottom: 10px;
        color: #2ed573;
    }
    .stat-card {
    border-radius: 15px;
    border: none;
    transition: transform 0.3s ease, box-shadow 0.3s ease;
    cursor: pointer;
}

.stat-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 25px rgba(0,0,0,0.1);
}

.alert-badge {
    position: absolute;
    top: -8px;
    right: -8px;
    background: #dc3545;
    color: white;
    border-radius: 50%;
    width: 25px;
    height: 25px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 12px;
    font-weight: bold;
}

</style>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" />


<script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>  
<div class="page-wrapper">
    <div class="container-fluid">
        <!-- Dashboard Header -->
        <div class="row page-titles">
            <div class="col-md-12 align-self-center">
                <h3 class="text-themecolor">Dashboard Overview</h3>
                <p class="text-muted"><?php echo date('l') .' '.date('d').'-'.date('m').'-'.date('Y'); ?></p>
            </div>
        </div>
        
        <!-- Summary Stats -->
        <div class="row">
            <div class="col-md-3">
                <div class="card stat-card" style="background: linear-gradient(45deg, #2ed573, #1e90ff);">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h4 class="text-white">₹<?php echo number_format($todaySalesTotal, 2); ?></h4>
                                <p class="text-white mb-0">Today's Sales</p>
                            </div>
                           
                            <i class="fa fa-folder-open "></i>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card stat-card" style="background: linear-gradient(45deg, #ff7f50, #ff6b81);">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h4 class="text-white">₹<?php echo number_format($monthlySalesTotal, 2); ?></h4>
                                <p class="text-white mb-0">Monthly Sales</p>
                            </div>
                            <i class="fa fa-file-upload"></i>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card stat-card" style="background: linear-gradient(45deg, #3742fa, #5352ed);">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h4 class="text-white"><?php echo $countLowStock2; ?></h4>
                                <p class="text-white mb-0">Total Invoices</p>
                            </div>
                            <i class="fas fa-file-invoice fa-2x text-white"></i>
                        </div>
                    </div>
                </div>
            </div>
           <!-- Low Stock Alerts Card (Clickable) -->
<div class="col-md-3">
    <div class="card stat-card" style="background: linear-gradient(45deg, #ffa502, #ff6348); cursor: pointer;" 
         onclick="window.location.href='lowStockAlerts.php'">
        <div class="card-body position-relative">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h4 class="text-white"><?php echo $lowStockAlertCount; ?></h4>
                    <p class="text-white mb-0">Low Stock Alerts  click>>>>></p>
                </div>
                <i class="fas fa-exclamation-triangle text-white"></i>
            </div>
            <?php if($lowStockAlertCount > 0): ?>
                <span class="alert-badge"><?php echo $lowStockAlertCount; ?></span>
            <?php endif; ?>
        </div>
    </div>
</div>

            <!-- Inventory Status -->

        </div>
<!-- Add Font Awesome if not already loaded -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css" integrity="sha512-zR5k5Y9P9LJ5c7oODn3iNw/Uc0Bk1mP4fG4iKjp4xwQZ0DgGFyvhG9U1wWJbHdfXpR+TQ1DnhP3sU6Rz+KqXpg==" crossorigin="anonymous" referrerpolicy="no-referrer" />

<div class="row">
    <div class="col-md-12">
        <div class="card">
          <!--   <div class="card-header text-center">
                <h4 class="card-title">Inventory Analytics</h4>
            </div> -->
            <div class="card-body">
                <div class="row text-center">

                    <!-- Total Products -->
                    <div class="col-md-3 col-6 mb-3">
                        <div class="card dashboard-card analytic-card" style="background: linear-gradient(135deg, #00f0ff, #0066ff);">
                            <div class="card-body">
                               <i class="fa fa-stethoscope"></i>
                                <h2 class="text-white mt-2"><?php echo $countLowStock; ?></h2>
                                <p class="text-light">Total Products</p>
                                <a href="product.php" class="btn btn-outline-light btn-sm">View All</a>
                            </div>
                        </div>
                    </div>

                    <!-- Total Manufacturers -->
                    <div class="col-md-3 col-6 mb-3">
                        <div class="card dashboard-card analytic-card" style="background: linear-gradient(135deg, #ff00ff, #ff66ff);">
                            <div class="card-body">
                                <i class="fa fa-cogs"></i>
                                <h2 class="text-white mt-2"><?php echo $countLowStock1; ?></h2>
                                <p class="text-light">Manufacturers</p>
                                <a href="brand.php" class="btn btn-outline-light btn-sm">View All</a>
                            </div>
                        </div>
                    </div>

                    <!-- Total Categories -->
                    <div class="col-md-3 col-6 mb-3">
                        <div class="card dashboard-card analytic-card" style="background: linear-gradient(135deg, #00ff99, #00cc66);">
                            <div class="card-body">
                               <i class="fa fa-folder-open"></i>
                                <h2 class="text-white mt-2"><?php 
                                    $categorySql = "SELECT COUNT(*) as total FROM categories WHERE categories_status = 1";
                                    $categoryQuery = $connect->query($categorySql);
                                    $categoryData = $categoryQuery->fetch_assoc();
                                    echo $categoryData['total']; 
                                ?></h2>
                                <p class="text-light">Categories</p>
                                <a href="#" class="btn btn-outline-light btn-sm">View All</a>
                            </div>
                        </div>
                    </div>

                    <!-- Total Customers -->
                    <div class="col-md-3 col-6 mb-3">
                        <div class="card dashboard-card analytic-card" style="background: linear-gradient(135deg, #ffcc00, #ff6600);">
                            <div class="card-body">
                               <i class="fa fa-users"></i>
                                <h2 class="text-white mt-2"><?php 
                                    $customerSql = "SELECT COUNT(DISTINCT clientName) as total FROM orders WHERE delete_status = 0";
                                    $customerQuery = $connect->query($customerSql);
                                    $customerData = $customerQuery->fetch_assoc();
                                    echo $customerData['total']; 
                                ?></h2>
                                <p class="text-light">Customers</p>
                                <a href="orders.php" class="btn btn-outline-light btn-sm">View All</a>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>

<style>
/* Analytics/Digital-style cards */
.analytic-card {
    border-radius: 12px;
    box-shadow: 0 8px 25px rgba(0,0,0,0.25);
    transition: transform 0.3s, box-shadow 0.3s;
    padding: 20px 0;
}

.analytic-card:hover {
    transform: translateY(-8px);
    box-shadow: 0 12px 40px rgba(0,0,0,0.35);
}

/* Animated icons */
.analytic-icon {
    animation: bounce 2s infinite;
    color: rgba(255,255,255,0.9);
}

@keyframes bounce {
    0%, 100% { transform: translateY(0); }
    50% { transform: translateY(-10px); }
}

/* Text styling */
.analytic-card h2 {
    font-family: 'Digital-7', monospace;
    font-weight: bold;
}

.analytic-card p {
    font-size: 0.9rem;
}

/* Buttons */
.analytic-card a.btn {
    margin-top: 8px;
}

/* Responsive spacing */
@media (max-width: 768px) {
    .col-6 {
        margin-bottom: 15px;
    }
}
</style>


        <!-- Quick Actions -->
  
        <!-- Charts and Graphs -->
        <div class="row">
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header" style="background: linear-gradient(90deg, #1e90ff, #00f0ff); border-radius: 8px 8px 0 0;">
    <h4 class="card-title text-white mb-0">Stock Overview</h4>
</div>

                    <div class="card-body">
                        <div id="stockChart" style="width:100%; height:300px;"></div>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header" style="background: linear-gradient(90deg, #ff7f50, #ff6b81); border-radius: 8px 8px 0 0; box-shadow: 0 0 10px rgba(255, 123, 100, 0.6); animation: glow 2s infinite alternate;">
    <h4 class="card-title text-white mb-0">Sales Trend (Last 7 Days)</h4>
</div>

<style>
@keyframes glow {
    0% {
        box-shadow: 0 0 5px rgba(255, 123, 100, 0.4);
    }
    50% {
        box-shadow: 0 0 15px rgba(255, 123, 100, 0.7);
    }
    100% {
        box-shadow: 0 0 5px rgba(255, 123, 100, 0.4);
    }
}
</style>

                    <div class="card-body">
                        <div id="salesChart" style="width:100%; height:300px;"></div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Recent Transactions and Top Products -->
        <div class="row">
            <div class="col-md-6">
                <div class="card">
                   <div class="card-header" style="background: linear-gradient(90deg, #00ff99, #00cc66); border-radius: 8px 8px 0 0; box-shadow: 0 0 10px rgba(0, 204, 102, 0.6); animation: glow-green 2s infinite alternate;">
    <h4 class="card-title text-white mb-0">Recent Transactions</h4>
</div>

<style>
@keyframes glow-green {
    0% {
        box-shadow: 0 0 5px rgba(0, 204, 102, 0.4);
    }
    50% {
        box-shadow: 0 0 15px rgba(0, 204, 102, 0.7);
    }
    100% {
        box-shadow: 0 0 5px rgba(0, 204, 102, 0.4);
    }
}
</style>

                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>Invoice #</th>
                                        <th>Customer</th>
                                        <th>Amount</th>
                                        <th>Status</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php while($transaction = $recentTransactionsQuery->fetch_assoc()): ?>
                                    <tr>
                                        <td><?php echo $transaction['uno']; ?></td>
                                        <td><?php echo substr($transaction['clientName'], 0, 15); ?>...</td>
                                        <td>₹<?php echo number_format($transaction['grandTotalValue'], 2); ?></td>
                                        <td>
                                            <?php if($transaction['paymentStatus'] == 1): ?>
                                                <span class="badge badge-success">Paid</span>
                                            <?php elseif($transaction['paymentStatus'] == 2): ?>
                                                <span class="badge badge-warning">Partial</span>
                                            <?php else: ?>
                                                <span class="badge badge-danger">Pending</span>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                    <?php endwhile; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="card">
                  <div class="card-header" style="background: linear-gradient(90deg, #ffa502, #ff6348); border-radius: 8px 8px 0 0; box-shadow: 0 0 10px rgba(255, 99, 72, 0.6); animation: glow-orange 2s infinite alternate;">
    <h4 class="card-title text-white mb-0">Top Selling Products</h4>
</div>

<style>
@keyframes glow-orange {
    0% {
        box-shadow: 0 0 5px rgba(255, 99, 72, 0.4);
    }
    50% {
        box-shadow: 0 0 15px rgba(255, 99, 72, 0.7);
    }
    100% {
        box-shadow: 0 0 5px rgba(255, 99, 72, 0.4);
    }
}
</style>

                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>Product</th>
                                        <th>Units Sold</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php while($product = $topProductsQuery->fetch_assoc()): ?>
                                    <tr>
                                        <td><?php echo $product['product_name']; ?></td>
                                        <td><?php echo $product['total_sold']; ?></td>
                                    </tr>
                                    <?php endwhile; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Inventory Status -->
     <div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header digital-card-header bg-gradient-purple">
                <h4 class="card-title text-white mb-0">Inventory Summary</h4>
            </div>
            <div class="card-body">
                <div class="row text-center">

                    <!-- Total Medicines -->
                    <div class="col-md-3 col-6 mb-3">
                        <div class="card dashboard-card digital-card" style="background: linear-gradient(135deg, #00f0ff, #0066ff);">
                            <div class="card-body">
                                <i class="fas fa-pills fa-2x text-white mb-2"></i>
                                <h2 class="text-white"><?php echo $countLowStock; ?></h2>
                                <p class="text-light">Total Products</p>
                                <a href="product.php" class="btn btn-outline-light btn-sm">View All</a>
                            </div>
                        </div>
                    </div>

                    <!-- Manufacturers -->
                    <div class="col-md-3 col-6 mb-3">
                        <div class="card dashboard-card digital-card" style="background: linear-gradient(135deg, #ff00ff, #ff66ff);">
                            <div class="card-body">
                                <i class="fas fa-industry fa-2x text-white mb-2"></i>
                                <h2 class="text-white"><?php echo $countLowStock1; ?></h2>
                                <p class="text-light">Manufacturers</p>
                                <a href="brand.php" class="btn btn-outline-light btn-sm">View All</a>
                            </div>
                        </div>
                    </div>

                    <!-- Expired Medicines -->
                    <div class="col-md-3 col-6 mb-3">
                        <div class="card dashboard-card digital-card" style="background: linear-gradient(135deg, #ffcc00, #ff6600);">
                            <div class="card-body position-relative">
                                <i class="fas fa-calendar-times fa-2x text-white mb-2"></i>
                                <h2 class="text-white"><?php echo $countLowStock3; ?></h2>
                                <p class="text-light">Expired Products</p>
                                <a href="expired.php" class="btn btn-outline-light btn-sm">Check Now</a>
                                <?php if($countLowStock3 > 0): ?>
                                    <span class="alert-badge">!</span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>

                    <!-- Low Stock Items -->
                    <div class="col-md-3 col-6 mb-3">
                        <div class="card dashboard-card digital-card" style="background: linear-gradient(135deg, #ff4d4d, #ff1a1a);">
                            <div class="card-body position-relative">
                                <i class="fas fa-exclamation-triangle fa-2x text-white mb-2"></i>
                                <h2 class="text-white"><?php echo $lowStockAlertCount; ?></h2>
                                <p class="text-light">Low Stock Items</p>
                                <a href="lowStockAlerts.php" class="btn btn-outline-light btn-sm">Check Now</a>
                                <?php if($lowStockAlertCount > 0): ?>
                                    <span class="alert-badge"><?php echo $lowStockAlertCount; ?></span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>

<style>
/* Digital cards */
.digital-card {
    border-radius: 12px;
    box-shadow: 0 8px 20px rgba(0,0,0,0.2);
    transition: transform 0.3s, box-shadow 0.3s;
}
.digital-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 12px 30px rgba(0,0,0,0.3);
}

/* Icons animation */
.digital-card i {
    animation: pulse 2s infinite;
}
@keyframes pulse {
    0% { transform: scale(1); opacity: 0.8; }
    50% { transform: scale(1.2); opacity: 1; }
    100% { transform: scale(1); opacity: 0.8; }
}

/* Card header style */
.digital-card-header {
    border-radius: 8px 8px 0 0;
    color: #fff;
    padding: 12px 20px;
    font-weight: bold;
}

/* Gradient examples for headers */
.bg-gradient-purple { background: linear-gradient(90deg, #9b59b6, #8e44ad); }

/* Alert badge */
.alert-badge {
    position: absolute;
    top: 5px;
    right: 10px;
    background: #ff3d3d;
    color: #fff;
    border-radius: 50%;
    padding: 5px 8px;
    font-weight: bold;
    animation: blink 1s infinite;
}
@keyframes blink {
    0%, 50%, 100% { opacity: 1; }
    25%, 75% { opacity: 0.3; }
}
</style>

    </div>
</div>

<?php include ('./constant/layout/footer.php');?>

<script>
$(function(){
    $(".preloader").fadeOut();
    
    // Initialize tooltips
    $('[data-toggle="tooltip"]').tooltip();
});

// Load Google Charts
google.charts.load('current', {'packages':['corechart']});
google.charts.setOnLoadCallback(drawCharts);

function drawCharts() {
    drawStockChart();
    drawSalesChart();
}

function drawStockChart() {
    var data = google.visualization.arrayToDataTable([
        ['Product', 'Quantity'],
        <?php
        $productSql = "SELECT product_name, quantity FROM product WHERE status = 1 ORDER BY quantity DESC LIMIT 10";
        $productQuery = $connect->query($productSql);
        while($product = $productQuery->fetch_assoc()) {
          echo "['".$product['product_name']."', ".(isset($product['quantity']) && $product['quantity'] ? $product['quantity'] : 0)."],";

        }
        ?>
    ]);

    var options = {
        title: 'Top 10 Products by Stock',
        is3D: true,
        pieSliceText: 'value',
        chartArea: {width: '90%', height: '80%'}
    };

    var chart = new google.visualization.PieChart(document.getElementById('stockChart'));
    chart.draw(data, options);
}

function drawSalesChart() {
    // This would ideally come from your database
    // For now, we'll use sample data
    var data = google.visualization.arrayToDataTable([
        ['Day', 'Sales'],
        ['Mon', 1000],
        ['Tue', 1170],
        ['Wed', 660],
        ['Thu', 1030],
        ['Fri', 1890],
        ['Sat', 1570],
        ['Sun', 1200]
    ]);

    var options = {
        title: 'Weekly Sales Performance',
        hAxis: {title: 'Day', titleTextStyle: {color: '#333'}},
        vAxis: {minValue: 0},
        chartArea: {width: '85%', height: '70%'}
    };

    var chart = new google.visualization.AreaChart(document.getElementById('salesChart'));
    chart.draw(data, options);
}
</script>