<?php
session_start();
include('./constant/connect.php');

if(isset($_POST['product_id'])) {
    $product_id = $_POST['product_id'];
    
    // Soft delete by updating status
    $sql = "UPDATE product SET status = 0 WHERE product_id = ?";
    $stmt = $connect->prepare($sql);
    $stmt->bind_param("i", $product_id);
    
    if($stmt->execute()) {
        $_SESSION['success_message'] = "Stock item deleted successfully!";
        echo json_encode(['success' => true]);
    } else {
        echo json_encode(['success' => false, 'message' => 'Error deleting stock item']);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Invalid request']);
}
?>