<?php

error_reporting(E_ALL);
ini_set('display_errors', 1);
// edit_order.php - Edit Order Page
include('./constant/layout/head.php');
include('./constant/layout/header.php');
include('./constant/layout/sidebar.php');
include('./constant/connect.php');

// Check if order ID is provided
$orderId = isset($_GET['id']) ? intval($_GET['id']) : 0;

if ($orderId <= 0) {
    echo "<script>window.location.href = 'Order.php';</script>";
    exit();
}

// Fetch order details
$orderSql = "SELECT * FROM orders WHERE id = $orderId";
$orderResult = $connect->query($orderSql);

if ($orderResult->num_rows == 0) {
    echo "<script>alert('Order not found!'); window.location.href = 'Order.php';</script>";
    exit();
}

$orderData = $orderResult->fetch_assoc();

// Fetch order items
$orderItemsSql = "SELECT * FROM order_item WHERE order_id = $orderId";
$orderItemsResult = $connect->query($orderItemsSql);
$orderItems = array();
while ($row = $orderItemsResult->fetch_assoc()) {
    $orderItems[] = $row;
}
?>

<div class="page-wrapper">
    <div class="row page-titles">
        <div class="col-md-5 align-self-center">
            <h3 class="text-primary">Edit Invoice</h3> 
        </div>
        <div class="col-md-7 align-self-center">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="javascript:void(0)">Home</a></li>
                <li class="breadcrumb-item"><a href="Order.php">Invoice Management</a></li>
                <li class="breadcrumb-item active">Edit Invoice</li>
            </ol>
        </div>
    </div>
    
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-title"></div>
                    <div id="edit-brand-messages"></div>
                    <!-- Success message container -->
                    <div id="success-message" class="alert alert-success" style="display: none;">
                        <button type="button" class="close" data-dismiss="alert">&times;</button>
                        <strong><i class="glyphicon glyphicon-ok-sign"></i></strong> Invoice updated successfully!
                    </div>
                    <div class="card-body">
                        <div class="input-states">
                            <form class="form-horizontal" method="POST" id="editOrderForm" action="php_action/editOrder.php">
                                <input type="hidden" name="orderId" value="<?php echo $orderId; ?>">
                                
                                <div class="form-group">
                                    <div class="row">
                                        <label class="col-sm-2 control-label">Invoice No</label>
                                        <div class="col-sm-4">
                                            <input type="text" class="form-control" placeholder="Invoice Number" value="<?php echo $orderData['uno']; ?>" autocomplete="off" name="uno" required readonly/>
                                        </div>

                                        <label class="col-sm-2 control-label">Invoice Date</label>
                                        <div class="col-sm-4">
                                            <input type="date" class="form-control" value="<?php echo $orderData['orderDate']; ?>" id="orderDate" name="orderDate" autocomplete="off" />
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="form-group">
                                    <div class="row">
                                        <label class="col-sm-2 control-label">Invoice Time</label>
                                        <div class="col-sm-4">
                                            <input type="time" class="form-control" value="<?php echo date('H:i', strtotime($orderData['orderDate'])); ?>" id="orderTime" name="orderTime" autocomplete="off" />
                                        </div>

                                        <label class="col-sm-2 control-label">Client Contact No.</label>
                                        <div class="col-sm-4">
                                            <input type="text" class="form-control" id="clientContact" name="clientContact" placeholder="Contact Number" value="<?php echo $orderData['clientContact']; ?>" autocomplete="off" pattern="^[0][1-9]\d{9}$|^[1-9]\d{9}$" required/>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="form-group">
                                    <div class="row">
                                        <label class="col-sm-2 control-label">Client Name</label>
                                        <div class="col-sm-4">
                                            <input type="text" class="form-control" id="clientName" name="clientName" placeholder="Client Name" value="<?php echo $orderData['clientName']; ?>" autocomplete="off" />
                                        </div>

                                        <label class="col-sm-2 control-label">GSTIN (Optional)</label>
                                        <div class="col-sm-4">
                                            <input type="text" class="form-control" id="gstn" name="gstn" placeholder="GSTIN Number" value="<?php echo $orderData['gstn'] ?? ''; ?>" autocomplete="off" />
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="table-responsive">               
                                    <table class="table" id="productTable">
                                        <thead>
                                            <tr>              
                                                <th style="width:20%;">Medicine</th>
                                                <th style="width:12%;">Chamber</th>
                                                <th style="width:8%;">Rate</th>
                                                <th style="width:8%;">Avail.</th>
                                                <th style="width:8%;">Quantity</th>
                                                <th style="width:8%;">SGST %</th>
                                                <th style="width:8%;">CGST %</th>
                                                <th style="width:8%;">Discount %</th>
                                                <th style="width:10%;">Total</th>             
                                                <th style="width:10%;">Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            $arrayNumber = 0;
                                            foreach ($orderItems as $index => $item) {
                                                // Get product details
                                                $productSql = "SELECT * FROM product WHERE product_id = '{$item['productName']}'";
                                                $productResult = $connect->query($productSql);
                                                $productData = $productResult->fetch_assoc();
                                                ?>
                                                <tr id="row<?php echo $index + 1; ?>" class="<?php echo $arrayNumber; ?>">                
                                                    <td>
                                                        <div class="form-group">
                                                            <select class="form-control select2-product" 
                                                                    name="productName[]" 
                                                                    id="productName<?php echo $index + 1; ?>" 
                                                                    onchange="getProductData(<?php echo $index + 1; ?>)" 
                                                                    style="height:60px; font-size:12px; padding-top:10px; padding-bottom:10px;">
                                                                <option value="">~~SELECT~~</option>
                                                                <?php
                                                                $productSql = "SELECT * FROM product WHERE active = 1 AND status = 1";
                                                                $productDataAll = $connect->query($productSql);

                                                                while($row = $productDataAll->fetch_array()) {                     
                                                                    $selected = ($row['product_id'] == $item['productName']) ? 'selected' : '';
                                                                    echo "<option value='".$row['product_id']."' 
                                                                            data-chamber='".$row['chamber']."'
                                                                            id='changeProduct".$row['product_id']."' $selected>".$row['product_name']."</option>";
                                                                }
                                                                ?>
                                                            </select>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <input type="text" name="chamber[]" id="chamber<?php echo $index + 1; ?>" value="<?php echo $productData['chamber'] ?? ''; ?>" autocomplete="off" class="form-control" readonly />
                                                    </td>
                                                    <td>                 
                                                        <input type="text" name="rate[]" id="rate<?php echo $index + 1; ?>" value="<?php echo $item['rate']; ?>" autocomplete="off" disabled="true" class="form-control" />                  
                                                        <input type="hidden" name="rateValue[]" id="rateValue<?php echo $index + 1; ?>" value="<?php echo $item['rate']; ?>" autocomplete="off" class="form-control" />                  
                                                    </td>
                                                    <td>
                                                        <div class="form-group">
                                                            <p id="available_quantity<?php echo $index + 1; ?>"><?php echo $productData['quantity'] ?? 0; ?></p>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div class="form-group">
                                                            <input type="number" name="quantity[]" id="quantity<?php echo $index + 1; ?>" onkeyup="getTotal(<?php echo $index + 1; ?>)" value="<?php echo $item['quantity']; ?>" autocomplete="off" class="form-control" min="1" />
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <input type="number" name="sgst_percentage[]" id="sgst_percentage<?php echo $index + 1; ?>" onkeyup="getTotal(<?php echo $index + 1; ?>)" value="<?php echo $item['sgst_percentage']; ?>" autocomplete="off" class="form-control" step="0.01" />
                                                    </td>
                                                    <td>
                                                        <input type="number" name="cgst_percentage[]" id="cgst_percentage<?php echo $index + 1; ?>" onkeyup="getTotal(<?php echo $index + 1; ?>)" value="<?php echo $item['cgst_percentage']; ?>" autocomplete="off" class="form-control" step="0.01" />
                                                    </td>
                                                    <td>
                                                        <input type="number" name="discount_percentage_item[]" id="discount_percentage_item<?php echo $index + 1; ?>" onkeyup="getTotal(<?php echo $index + 1; ?>)" value="<?php echo $item['discount_percentage']; ?>" autocomplete="off" class="form-control" step="0.01" />
                                                    </td>
                                                    <td>                 
                                                        <input type="text" name="total[]" id="total<?php echo $index + 1; ?>" value="<?php echo $item['total']; ?>" autocomplete="off" class="form-control" disabled="true" />                  
                                                        <input type="hidden" name="totalValue[]" id="totalValue<?php echo $index + 1; ?>" value="<?php echo $item['total']; ?>" autocomplete="off" class="form-control" />                  
                                                    </td>
                                                    <td>
                                                        <button type="button" class="btn btn-primary btn-flat" onclick="addRow()" id="addRowBtn"><i class="fa fa-plus"></i></button>
                                                        <?php if ($index > 0) { ?>
                                                            <button type="button" class="btn btn-danger removeProductRowBtn" onclick="removeProductRow(<?php echo $index + 1; ?>)"><i class="fa fa-trash"></i></button>
                                                        <?php } ?>
                                                    </td>
                                                </tr>
                                                <?php
                                                $arrayNumber++;
                                            }
                                            ?>
                                        </tbody>          
                                    </table>
                                </div>
                                
                                <div class="form-group">
                                    <div class="row">
                                        <label class="col-sm-2 control-label">Sub Amount</label>
                                        <div class="col-sm-4">
                                            <input type="text" class="form-control" id="subTotal" name="subTotal" value="<?php echo $orderData['subTotal']; ?>" disabled="true" />
                                            <input type="hidden" class="form-control" id="subTotalValue" name="subTotalValue" value="<?php echo $orderData['subTotal']; ?>" />
                                        </div>

                                        <label for="totalAmount" class="col-sm-2 control-label">Total Amount</label>
                                        <div class="col-sm-4">
                                            <input type="text" class="form-control" id="totalAmount" name="totalAmount" value="<?php echo $orderData['totalAmount']; ?>" disabled="true"/>
                                            <input type="hidden" class="form-control" id="totalAmountValue" name="totalAmountValue" value="<?php echo $orderData['totalAmount']; ?>" />
                                        </div>
                                    </div>
                                </div>
                               
                                <div class="form-group">
                                    <div class="row">
                                        <label for="discount_percentage" class="col-sm-2 control-label">Overall Discount %</label>
                                        <div class="col-sm-4">
                                            <input type="number" class="form-control" id="discount_percentage" name="discount_percentage" onkeyup="discountFunc()" value="<?php echo $orderData['discount_percentage']; ?>" autocomplete="off" step="0.01" />
                                        </div>
                                        <label for="grandTotal" class="col-sm-2 control-label">Grand Total</label>
                                        <div class="col-sm-4">
                                            <input type="text" class="form-control" id="grandTotal" name="grandTotal" value="<?php echo $orderData['grandTotalValue']; ?>" disabled="true" />
                                            <input type="hidden" class="form-control" id="grandTotalValue" name="grandTotalValue" value="<?php echo $orderData['grandTotalValue']; ?>" />
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="form-group">
                                    <div class="row">
                                        <label for="sgst_total" class="col-sm-2 control-label">Total SGST</label>
                                        <div class="col-sm-4">
                                            <input type="text" class="form-control" id="sgst_total" name="sgst_total" value="<?php echo $orderData['sgst_total']; ?>" readonly="true" />
                                            <input type="hidden" class="form-control" id="sgst_totalValue" name="sgst_totalValue" value="<?php echo $orderData['sgst_total']; ?>" />
                                        </div>

                                        <label for="cgst_total" class="col-sm-2 control-label">Total CGST</label>
                                        <div class="col-sm-4">
                                            <input type="text" class="form-control" id="cgst_total" name="cgst_total" value="<?php echo $orderData['cgst_total']; ?>" readonly="true" />
                                            <input type="hidden" class="form-control" id="cgst_totalValue" name="cgst_totalValue" value="<?php echo $orderData['cgst_total']; ?>" />
                                        </div>
                                    </div>
                                </div>
                               
                                <div class="form-group">
                                    <div class="row">
                                        <label for="paid" class="col-sm-2 control-label">Paid Amount</label>
                                        <div class="col-sm-4">
                                            <input type="text" class="form-control" id="paid" name="paid" value="<?php echo $orderData['paid']; ?>" autocomplete="off" onkeyup="paidAmount()" />
                                        </div>

                                        <label for="due" class="col-sm-2 control-label">Due Amount</label>
                                        <div class="col-sm-4">
                                            <input type="text" class="form-control" id="due" name="due" value="<?php echo $orderData['dueValue']; ?>" disabled="true" />
                                            <input type="hidden" class="form-control" id="dueValue" name="dueValue" value="<?php echo $orderData['dueValue']; ?>" />
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="form-group">
                                    <div class="row">
                                        <label for="paymentType" class="col-sm-2 control-label">Payment Type</label>
                                        <div class="col-sm-4">
                                            <select class="form-control" name="paymentType" id="paymentType">
                                                <option value="">~~SELECT~~</option>
                                                <option value="2" <?php echo ($orderData['paymentType'] == 2) ? 'selected' : ''; ?>>Cash</option>
                                                <option value="4" <?php echo ($orderData['paymentType'] == 4) ? 'selected' : ''; ?>>Phone Pe</option>
                                                <option value="5" <?php echo ($orderData['paymentType'] == 5) ? 'selected' : ''; ?>>Google Pay</option>
                                                <option value="6" <?php echo ($orderData['paymentType'] == 6) ? 'selected' : ''; ?>>Amazon Pay</option>
                                                <option value="1" <?php echo ($orderData['paymentType'] == 1) ? 'selected' : ''; ?>>Cheque</option>
                                                <option value="3" <?php echo ($orderData['paymentType'] == 3) ? 'selected' : ''; ?>>Credit Card</option>
                                            </select>
                                        </div>
                                       
                                        <label for="paymentStatus" class="col-sm-2 control-label">Payment Status</label>
                                        <div class="col-sm-4">
                                            <select class="form-control" name="paymentStatus" id="paymentStatus">
                                                <option value="">~~SELECT~~</option>
                                                <option value="1" <?php echo ($orderData['paymentStatus'] == 1) ? 'selected' : ''; ?>>Full Payment</option>
                                                <option value="2" <?php echo ($orderData['paymentStatus'] == 2) ? 'selected' : ''; ?>>Advance Payment</option>
                                                <option value="3" <?php echo ($orderData['paymentStatus'] == 3) ? 'selected' : ''; ?>>No Payment</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="form-group submitButtonFooter">
                                    <div class="col-sm-offset-2 col-sm-10">
                                        <button type="submit" id="editOrderBtn" data-loading-text="Loading..." class="btn btn-success btn-flat m-b-30 m-t-30"><i class="glyphicon glyphicon-ok-sign"></i> Update Invoice</button>
                                        <button type="button" class="btn btn-danger btn-flat m-b-30 m-t-30" onclick="window.location.href='Order.php'"><i class="glyphicon glyphicon-remove"></i> Cancel</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include('./constant/layout/footer.php');?>

<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<script>
// JavaScript functions for edit order page
$(document).ready(function () {
    $('.select2-product').select2({
        placeholder: "Search for a medicine",
        allowClear: true
    });
    
    // Auto focus search field when select2 opens
    $(document).on('select2:open', () => {
        document.querySelector('.select2-container--open .select2-search__field').focus();
    });

    // Check if we should show success message from session storage
    if (sessionStorage.getItem('showEditSuccessMessage') === 'true') {
        $('#success-message').show();
        sessionStorage.removeItem('showEditSuccessMessage');
    }
    
    // Recalculate totals on page load
    setTimeout(function() {
        var tableLength = $("#productTable tbody tr").length;
        for (var i = 1; i <= tableLength; i++) {
            getTotal(i);
        }
        subAmount();
    }, 500);
});

// All calculation functions (getTotal, subAmount, discountFunc, paidAmount) remain the same as in your original code
// These functions are identical to the ones in your create order page

/* ================= CALCULATION FUNCTIONS =================== */
function getTotal(row = null) {
    if (!row) { alert('no row !! please refresh the page'); return; }

    var rate = Number($("#rate" + row).val());
    var quantity = Number($("#quantity" + row).val());
    var sgstPercentage = Number($("#sgst_percentage" + row).val());
    var cgstPercentage = Number($("#cgst_percentage" + row).val());
    var discountPercentage = Number($("#discount_percentage_item" + row).val());

    var baseAmount = rate * quantity;
    var discountAmount = (baseAmount * discountPercentage) / 100;
    var discountedAmount = baseAmount - discountAmount;

    var sgstAmount = (discountedAmount * sgstPercentage) / 100;
    var cgstAmount = (discountedAmount * cgstPercentage) / 100;

    var total = discountedAmount + sgstAmount + cgstAmount;
    total = total.toFixed(2);

    $("#total" + row).val(total);
    $("#totalValue" + row).val(total);

    subAmount();
}

function subAmount() {
    var tableProductLength = $("#productTable tbody tr").length;
    var totalSubAmount = 0, totalSgst = 0, totalCgst = 0, totalDiscount = 0;

    for (x = 0; x < tableProductLength; x++) {
        var tr = $("#productTable tbody tr")[x];
        var count = $(tr).attr('id');
        count = count.substring(3);

        totalSubAmount += Number($("#total" + count).val());

        var rate = Number($("#rate" + count).val());
        var quantity = Number($("#quantity" + count).val());
        var sgstPercentage = Number($("#sgst_percentage" + count).val());
        var cgstPercentage = Number($("#cgst_percentage" + count).val());
        var discountPercentage = Number($("#discount_percentage_item" + count).val());

        var productSubtotal = rate * quantity;
        var productDiscount = (productSubtotal * discountPercentage) / 100;
        totalDiscount += productDiscount;

        var discountedAmount = productSubtotal - productDiscount;
        totalSgst += (discountedAmount * sgstPercentage) / 100;
        totalCgst += (discountedAmount * cgstPercentage) / 100;
    }

    totalSubAmount = totalSubAmount.toFixed(2);
    totalSgst = totalSgst.toFixed(2);
    totalCgst = totalCgst.toFixed(2);
    totalDiscount = totalDiscount.toFixed(2);

    $("#subTotal, #subTotalValue").val(totalSubAmount);
    $("#sgst_total, #sgst_totalValue").val(totalSgst);
    $("#cgst_total, #cgst_totalValue").val(totalCgst);

    var totalAmount = Number(totalSubAmount).toFixed(2);
    $("#totalAmount, #totalAmountValue").val(totalAmount);

    var discountPercentage = $("#discount_percentage").val();
    if (discountPercentage) {
        var discountAmount = (Number(totalAmount) * Number(discountPercentage)) / 100;
        var grandTotal = Number(totalAmount) - discountAmount;
        grandTotal = grandTotal.toFixed(2);
        $("#grandTotal, #grandTotalValue").val(grandTotal);
    } else {
        $("#grandTotal, #grandTotalValue").val(totalAmount);
    }

    var paidAmount = $("#paid").val();
    if (paidAmount) {
        paidAmount = Number($("#grandTotal").val()) - Number(paidAmount);
        paidAmount = paidAmount.toFixed(2);
        $("#due, #dueValue").val(paidAmount);
    } else {
        $("#due, #dueValue").val($("#grandTotal").val());
    }
}

function discountFunc() {
    var discountPercentage = $("#discount_percentage").val();
    var totalAmount = Number($("#totalAmount").val()).toFixed(2);

    if (totalAmount) {
        var discountAmount = (Number(totalAmount) * Number(discountPercentage)) / 100;
        var grandTotal = Number(totalAmount) - discountAmount;
        grandTotal = grandTotal.toFixed(2);
        $("#grandTotal, #grandTotalValue").val(grandTotal);
    }

    var paid = $("#paid").val();
    var dueAmount;
    if (paid) {
        dueAmount = Number($("#grandTotal").val()) - Number($("#paid").val());
        dueAmount = dueAmount.toFixed(2);
        $("#due, #dueValue").val(dueAmount);
    } else {
        $("#due, #dueValue").val($("#grandTotal").val());
    }
}

function paidAmount() {
    var grandTotal = $("#grandTotal").val();
    if (grandTotal) {
        var dueAmount = Number($("#grandTotal").val()) - Number($("#paid").val());
        dueAmount = dueAmount.toFixed(2);
        $("#due, #dueValue").val(dueAmount);
    }
}

/* ================= DYNAMIC ROWS =================== */
function addRow() {
    $("#addRowBtn").button("loading");

    var tableLength = $("#productTable tbody tr").length;
    var count = tableLength > 0 ? Number($("#productTable tbody tr:last").attr('id').substring(3)) + 1 : 1;
    var arrayNumber = tableLength > 0 ? Number($("#productTable tbody tr:last").attr('class')) + 1 : 0;

    $.ajax({
        url: 'php_action/fetchProductData.php',
        type: 'post',
        dataType: 'json',
        success: function (response) {
            $("#addRowBtn").button("reset");
            
            var tr = '<tr id="row' + count + '" class="' + arrayNumber + '">' +
                '<td><select class="form-control select2-product" name="productName[]" id="productName' + count + '" onchange="getProductData(' + count + ')" >' +
                '<option value="">~~SELECT~~</option>';
            $.each(response, function (index, value) {
                tr += '<option value="' + value[0] + '">' + value[1] + '</option>';
            });
            tr += '</select></td>' +
                '<td><input type="text" name="chamber[]" id="chamber' + count + '" autocomplete="off" class="form-control" readonly /></td>' +
                '<td><input type="text" name="rate[]" id="rate' + count + '" disabled class="form-control"/>' +
                '<input type="hidden" name="rateValue[]" id="rateValue' + count + '"/></td>' +
                '<td><p id="available_quantity' + count + '"></p></td>' +
                '<td><input type="number" name="quantity[]" id="quantity' + count + '" onkeyup="getTotal(' + count + ')" min="1" class="form-control"/></td>' +
                '<td><input type="number" name="sgst_percentage[]" id="sgst_percentage' + count + '" onkeyup="getTotal(' + count + ')" value="0" step="0.01" class="form-control"/></td>' +
                '<td><input type="number" name="cgst_percentage[]" id="cgst_percentage' + count + '" onkeyup="getTotal(' + count + ')" value="0" step="0.01" class="form-control"/></td>' +
                '<td><input type="number" name="discount_percentage_item[]" id="discount_percentage_item' + count + '" onkeyup="getTotal(' + count + ')" value="0" step="0.01" class="form-control"/></td>' +
                '<td><input type="text" name="total[]" id="total' + count + '" disabled class="form-control"/>' +
                '<input type="hidden" name="totalValue[]" id="totalValue' + count + '"/></td>' +
                '<td><button type="button" class="btn btn-primary btn-flat" onclick="addRow()" id="addRowBtn"><i class="fa fa-plus"></i></button>' +
                '<button type="button" class="btn btn-danger removeProductRowBtn" onclick="removeProductRow(' + count + ')"><i class="fa fa-trash"></i></button></td>' +
                '</tr>';

            if (tableLength > 0) {
                $("#productTable tbody tr:last").after(tr);
            } else {
                $("#productTable tbody").append(tr);
            }

            $('.select2-product').select2({
                placeholder: "Search for a medicine",
                allowClear: true
            });
        },
        error: function (xhr) {
            $("#addRowBtn").button("reset");
            console.error('fetchProductData.php failed', xhr.responseText);
            alert('Could not load product list.');
        }
    });
}

function removeProductRow(row = null) {
    if (!row) { alert('error! Refresh the page again'); return; }
    $("#row" + row).remove();
    subAmount();
}

/* ================= FETCH SELECTED PRODUCT =================== */
function getProductData(row = null) {
    if (!row) { alert('no row! please refresh the page'); return; }

    var productId = $("#productName" + row).val();
    if (productId === "") {
        $("#rate" + row).val("");
        $("#quantity" + row).val("");
        $("#total" + row).val("");
        return;
    }

    $.ajax({
        url: 'php_action/fetchSelectedProduct.php',
        type: 'post',
        data: { productId: productId },
        dataType: 'json',
        success: function (response) {
            $("#rate" + row).val(response.rate);
            $("#rateValue" + row).val(response.rate);
            $("#quantity" + row).val(1);
            $("#available_quantity" + row).text(response.quantity);
            $("#chamber" + row).val(response.chamber);
            
            // Set default GST values from database if available
            if (response.sgst && response.sgst > 0) {
                $("#sgst_percentage" + row).val(response.sgst);
            }
            if (response.cgst && response.cgst > 0) {
                $("#cgst_percentage" + row).val(response.cgst);
            }
            
            getTotal(row);
        },
        error: function (xhr) {
            console.error('fetchSelectedProduct.php failed', xhr.responseText);
            alert('Could not fetch product data.');
        }
    });
}

/* ================= FORM SUBMISSION =================== */
$("#editOrderForm").unbind('submit').bind('submit', function () {
    var form = $(this);
    $('.form-group').removeClass('has-error').removeClass('has-success');
    $('.text-danger').remove();

    // Validate required fields
    var requiredFields = ['orderDate', 'orderTime', 'clientName', 'clientContact', 'paymentType', 'paymentStatus'];
    var isValid = true;

    $.each(requiredFields, function (index, field) {
        var value = $("#" + field).val();
        if (value == "") {
            $("#" + field).after('<p class="text-danger"> This field is required </p>');
            $("#" + field).closest('.form-group').addClass('has-error');
            isValid = false;
        } else {
            $("#" + field).closest('.form-group').addClass('has-success');
        }
    });

    // Validate product rows
    var productRows = $("#productTable tbody tr");
    if (productRows.length == 0) {
        $("#productTable").after('<p class="text-danger"> At least one product is required </p>');
        isValid = false;
    }

    productRows.each(function () {
        var row = $(this);
        var productName = row.find('select[name="productName[]"]').val();
        var quantity = row.find('input[name="quantity[]"]').val();
        if (!productName) {
            row.find('select[name="productName[]"]').after('<p class="text-danger"> Product is required </p>');
            isValid = false;
        }
        if (!quantity || quantity < 1) {
            row.find('input[name="quantity[]"]').after('<p class="text-danger"> Valid quantity is required </p>');
            isValid = false;
        }
    });

    if (!isValid) return false;

    // Submit via AJAX
    $("#editOrderBtn").button('loading');

    $.ajax({
        url: form.attr('action'),
        type: form.attr('method'),
        data: form.serialize(),
        dataType: 'json',
        success: function (response) {
            $("#editOrderBtn").button('reset');
            $(".text-danger").remove();
            $('.form-group').removeClass('has-error').removeClass('has-success');

            if (response.success === true) {
                // Show success message
                $('#success-message').show();
                
                // Store success state in session storage for page refresh
                sessionStorage.setItem('showEditSuccessMessage', 'true');
                
                // Redirect to invoice management page after 2 seconds
                setTimeout(function() {
                    window.location.href = 'Order.php';
                }, 2000);
            } else {
                alert(response.messages);
            }
        },
        error: function (xhr) {
            $("#editOrderBtn").button('reset');
            console.error('edit order failed', xhr.status, xhr.responseText);
            alert('Error submitting form. Server says:\n' + xhr.responseText);
        }
    });

    return false;
});
</script>