<?php include('./constant/layout/head.php'); ?>
<?php include('./constant/layout/header.php'); ?>
<?php include('./constant/layout/sidebar.php'); ?>
<?php include('../constant/connect.php'); ?>

<div class="page-wrapper">
    <div class="row page-titles">
        <div class="col-md-5 align-self-center">
            <h3 class="text-primary">Datewise Expiry Medicine Report Management</h3>
        </div>
        <div class="col-md-7 align-self-center">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="javascript:void(0)">Home</a></li>
                <li class="breadcrumb-item active">>Datewise Report</li>
            </ol>
        </div>
    </div>

    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-12" >
                <div class="card">
                    <div class="card-body">
                        <div class="input-states">
                            <form class="form-horizontal" action="getproductreport.php" method="post" id="getOrderReportForm">
                                <div class="form-group">
                                    <div class="row">
                                        <label class="col-sm-3 control-label">Start Date</label>
                                        <div class="col-sm-9">
                                            <input type="date" class="form-control soft-input" id="startDate" name="startDate" placeholder="Start Date" />
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="row">
                                        <label class="col-sm-3 control-label">End Date</label>
                                        <div class="col-sm-9">
                                            <input type="date" class="form-control soft-input" id="endDate" name="endDate" placeholder="End Date" />
                                        </div>
                                    </div>
                                </div>
                                <button type="submit" id="generateReportBtn" class="btn soft-btn btn-primary m-b-30 m-t-30">Generate Report</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

</div>

<style>
/* Soft UI Inputs & Buttons */
.soft-input {
    border-radius: 12px;
    border: 1px solid #d1d9e6;
    padding: 10px 12px;
    box-shadow: inset 3px 3px 6px #d1d9e6, inset -3px -3px 6px #ffffff;
    transition: all 0.3s ease;
}

.soft-input:focus {
    border-color: #4a6cf7;
    box-shadow: inset 2px 2px 5px #c1c7d0, inset -2px -2px 5px #ffffff;
    outline: none;
}

.soft-btn {
    padding: 8px 16px;
    border-radius: 12px;
    box-shadow: 4px 4px 12px #d1d9e6, -4px -4px 12px #ffffff;
    transition: all 0.3s ease;
    font-weight: 500;
    cursor: pointer;
    border: none;
}

.soft-btn:hover {
    transform: translateY(-2px);
    box-shadow: 2px 2px 8px #c1c7d0, -2px -2px 8px #ffffff;
}

/* Card */
.card {
    background: #f7f9fc;
    border-radius: 15px;
    box-shadow: 6px 6px 12px #d1d9e6, -6px -6px 12px #ffffff;
}

/* General Page Styling */
body, .page-wrapper {
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    color: #4a4a4a;
}

/* Breadcrumbs */
.breadcrumb {
    background: transparent;
    padding: 0;
    margin-bottom: 0;
}

.breadcrumb a {
    color: #888;
    text-decoration: none;
}

.breadcrumb .active {
    color: #4a6cf7;
}
</style>

<script>
$(document).ready(function() {
    $("#startDate").date();
    $("#endDate").date();

    $("#getOrderReportForm").unbind('submit').bind('submit', function() {
        var startDate = $("#startDate").val();
        var endDate = $("#endDate").val();

        if(startDate == "" || endDate == "") {
            if(startDate == "") {
                $("#startDate").closest('.form-group').addClass('has-error');
                $("#startDate").after('<p class="text-danger">The Start Date is required</p>');
            } else {
                $(".form-group").removeClass('has-error');
                $(".text-danger").remove();
            }

            if(endDate == "") {
                $("#endDate").closest('.form-group').addClass('has-error');
                $("#endDate").after('<p class="text-danger">The End Date is required</p>');
            } else {
                $(".form-group").removeClass('has-error');
                $(".text-danger").remove();
            }
        } else {
            $(".form-group").removeClass('has-error');
            $(".text-danger").remove();

            var form = $(this);

            $.ajax({
                url: form.attr('action'),
                type: form.attr('method'),
                data: form.serialize(),
                dataType: 'date',
                success:function(response) {
                    var mywindow = window.open('', 'Rupee Invoice System', 'height=400,width=600');
                    mywindow.document.write('<html><head><title>Order Report Slip</title></head><body>');
                    mywindow.document.write(response);
                    mywindow.document.write('</body></html>');
                    mywindow.document.close();
                    mywindow.focus();
                    mywindow.print();
                    mywindow.close();
                }
            });
        }

        return false;
    });
});
</script>

<?php include('./constant/layout/footer.php'); ?>
