<?php include('./constant/layout/head.php'); ?>
<?php include('./constant/layout/header.php'); ?>
<?php include('./constant/layout/sidebar.php'); ?>
<?php include('../constant/connect.php'); ?>

<div class="page-wrapper">
    <div class="container-fluid">
        <div class="card">
            <div class="card-body">
                <button class="btn soft-btn btn-primary mb-3" onclick="printReport()">Print Report</button>
                <table class="soft-table" border="1" cellspacing="0" cellpadding="0">
                    <thead>
                        <tr>
                            <th>Medicine Name</th>
                            <th>Manufacturer Name</th>
                            <th>Quantity</th>
                            <th>MRP</th>
                            <th>Exp Date</th>
                            <th>Added Date</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php 
                        $query = $connect->query("SELECT * FROM product WHERE status = 1");
                        $totalAmount = 0;
                        while ($result = $query->fetch_assoc()) { ?>
                            <tr>
                                <?php $today = date('Y-m-d'); ?>
                                <td>
                                    <?php if($result['expdate'] > $today) { ?>
                                        <span class="label label-success"><?php echo $result['product_name']; ?></span>
                                    <?php } else { ?>
                                        <span class="label label-danger"><?php echo $result['product_name']; ?></span>
                                    <?php } ?>
                                </td>
                                <td><center><?php echo $result['brand_id']; ?></center></td>
                                <td><center><?php echo $result['quantity']; ?></center></td>
                                <td><center><?php echo $result['mrp']; ?></center></td>
                                <td><center><?php echo $result['expdate']; ?></center></td>
                                <td><center><?php echo $result['added_date']; ?></center></td>
                            </tr>
                        <?php $totalAmount += $result['mrp']; } ?>
                        <tr>
                            <td colspan="3"><center>Total Amount</center></td>
                            <td><center><?php echo $totalAmount; ?></center></td>
                            <td colspan="2"></td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<style>
/* Soft UI Table */
.soft-table {
    width: 100%;
    border-collapse: collapse;
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
}

.soft-table th, .soft-table td {
    padding: 10px 12px;
    text-align: center;
    border: 1px solid #d1d9e6;
}

.soft-table th {
    background: #f0f4f8;
}

.label {
    padding: 4px 8px;
    border-radius: 6px;
    color: #fff;
    font-weight: 500;
}

.label-success {
    background-color: #28a745;
}

.label-danger {
    background-color: #dc3545;
}

/* Soft Button */
.soft-btn {
    padding: 8px 16px;
    border-radius: 12px;
    box-shadow: 4px 4px 12px #d1d9e6, -4px -4px 12px #ffffff;
    transition: all 0.3s ease;
    font-weight: 500;
    cursor: pointer;
    border: none;
}

.soft-btn:hover {
    transform: translateY(-2px);
    box-shadow: 2px 2px 8px #c1c7d0, -2px -2px 8px #ffffff;
}

/* Card */
.card {
    background: #f7f9fc;
    border-radius: 15px;
    box-shadow: 6px 6px 12px #d1d9e6, -6px -6px 12px #ffffff;
}
</style>

<script>
function printReport() {
    var divToPrint = document.querySelector('.card-body').innerHTML;
    var newWin = window.open('', 'Print-Window', 'height=600,width=800');
    newWin.document.open();
    newWin.document.write('<html><head><title>Report</title></head><body>');
    newWin.document.write(divToPrint);
    newWin.document.write('</body></html>');
    newWin.document.close();
    newWin.focus();
    newWin.print();
    newWin.close();
}
</script>

<?php include('./constant/layout/footer.php'); ?>
