<?php 
session_start();
if (empty($_SESSION["userId"])) {
    header("Location: login.php");
    exit();
}

include('./constant/connect.php');

// Get order ID from URL
$order_id = $_GET['id'];

// Fetch order details
$order_sql = "SELECT * FROM orders WHERE id = '$order_id'";
$order_result = $connect->query($order_sql);
$order = $order_result->fetch_assoc();

// Fetch order items
$items_sql = "SELECT oi.*, p.product_name, p.bno, p.expdate, p.mrp as product_mrp 
              FROM order_item oi 
              LEFT JOIN product p ON oi.product_id = p.product_id 
              WHERE oi.order_id = '$order_id'";
$items_result = $connect->query($items_sql);

// Fetch company details
$company_sql = "SELECT * FROM system_settings WHERE id = 1";
$company_result = $connect->query($company_sql);
$company = $company_result->fetch_assoc();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Invoice - <?php echo $order['uno']; ?></title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 20px;
            color: #000;
            background-color: #fff;
            font-size: 12px;
            line-height: 1.2;
        }
        .invoice-box {
            max-width: 800px;
            margin: auto;
            padding: 10px;
            border: 1px solid #000;
            line-height: 1.2;
        }
        .header-section {
            text-align: center;
            margin-bottom: 10px;
            border-bottom: 1px solid #000;
            padding-bottom: 5px;
        }
        .company-name {
            font-size: 16px;
            font-weight: bold;
            margin-bottom: 3px;
            text-transform: uppercase;
        }
        .company-address {
            font-size: 10px;
            margin-bottom: 3px;
        }
        .patient-info {
            margin-bottom: 8px;
        }
        .info-line {
            margin-bottom: 2px;
        }
        .section-title {
            font-weight: bold;
            margin-bottom: 3px;
        }
        .gst-info {
            text-align: center;
            margin: 5px 0;
            font-size: 10px;
            font-weight: bold;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin: 5px 0;
            font-size: 10px;
        }
        table th, table td {
            border: 1px solid #000;
            padding: 2px 4px;
            text-align: left;
        }
        table th {
            background-color: #f0f0f0;
            font-weight: bold;
        }
        .totals-section {
            margin-top: 10px;
        }
        .amount-in-words {
            margin: 5px 0;
            font-style: italic;
            border-top: 1px solid #000;
            padding-top: 3px;
            font-size: 10px;
        }
        .footer-section {
            margin-top: 10px;
            font-size: 9px;
        }
        .terms-conditions {
            margin-bottom: 5px;
        }
        .signature-section {
            text-align: right;
            margin-top: 15px;
        }
        .print-button {
            text-align: center;
            margin: 20px 0;
        }
        .dashed-line {
            border-top: 1px dashed #000;
            margin: 5px 0;
        }
        .center-text {
            text-align: center;
        }
        .right-text {
            text-align: right;
        }
        @media print {
            .print-button {
                display: none;
            }
            body {
                padding: 0;
            }
            .invoice-box {
                border: 1px solid #000;
                box-shadow: none;
            }
        }
    </style>
</head>
<body>
    <div class="print-button">
        <button onclick="window.print()" style="padding: 10px 20px; background: #4a6cf7; color: white; border: none; border-radius: 5px; cursor: pointer;">
            Print Invoice
        </button>
        <button onclick="window.history.back()" style="padding: 10px 20px; background: #6c757d; color: white; border: none; border-radius: 5px; cursor: pointer;">
            Go Back
        </button>
    </div>

    <div class="invoice-box">
        <!-- Header Section -->
        <div class="header-section">
            <div class="company-name"><?php echo $company['company'] ?? 'SHREE MEDICALS'; ?></div>
            <div class="company-address">
                <?php echo $company['system_name'] ?? 'L.G.F. SHOP NO. 02 ELINCO CORPORATE CHAMBER'; ?><br>
                <?php echo $company['address'] ?? 'C/PP LOHIA HOSPITAL VIBHUTI KHAND'; ?><br>
                Phone: <?php echo $company['phone'] ?? '+959140483,7007175269'; ?>
            </div>
        </div>

        <!-- Patient and Doctor Information -->
        <div class="patient-info">
            <div class="info-line">
                <strong>Patient Name :</strong> <?php echo $order['clientName'] ?? 'CASH'; ?>
            </div>
            <div class="info-line">
                <strong>Patient Address :</strong> <?php echo $order['address'] ?? ''; ?>
            </div>
           
        </div>

        <!-- GST Information Line -->
        <div class="gst-info">
            <?php 
            $gstNumber = "07AABCS1429B1Z1"; // You can store this in system_settings
            echo "GSTIN: " . $gstNumber . " | ";
            echo "DL No.: UP-32200004469,UP32210004464";
            ?>
        </div>

        <!-- Dashed Line -->
        <div class="dashed-line"></div>

        <!-- Products Section Title -->
       

        <!-- Dashed Line -->
        <div class="dashed-line"></div>

        <!-- Invoice Title -->
        <div class="section-title center-text">CASH GST INVOICE</div>

        <!-- Items Table -->
        <table>
            <thead>
                <tr>
                    <th>Pack</th>
                    <th>BATCH</th>
                    <th>EXP.</th>
                    <th>QTY</th>
                    <th>MRP</th>
                    <th>Disc%</th>
                    <th>AMOUNT</th>
                </tr>
            </thead>
            <tbody>
                <?php 
                $counter = 1;
                $grandTotal = 0;
                while($item = $items_result->fetch_assoc()): 
                    $batch = $item['bno'] ?? 'N/A';
                    $expiry = $item['expdate'] ? date('m/y', strtotime($item['expdate'])) : 'N/A';
                    $quantity = $item['quantity'];
                    $mrp = $item['product_mrp'] ?? $item['rate'];
                    $discount = $item['discount_percentage'] ?? 0;
                    $amount = $item['total'];
                    $grandTotal += $amount;
                ?>
                <tr>
                    <td>1*1</td>
                    <td><?php echo $batch; ?></td>
                    <td><?php echo $expiry; ?></td>
                    <td><?php echo $quantity; ?></td>
                    <td>₹<?php echo number_format($mrp, 2); ?></td>
                    <td><?php echo $discount; ?>%</td>
                    <td>₹<?php echo number_format($amount, 2); ?></td>
                </tr>
                <?php endwhile; ?>
            </tbody>
        </table>

        <!-- GST Calculation -->
        <div class="gst-info">
            <?php
            $taxableAmount = $order['subTotal'] ?? $grandTotal;
            $sgstPercent = $order['sgst_percentage'] ?? 2.5;
            $cgstPercent = $order['cgst_percentage'] ?? 2.5;
            $sgstAmount = ($taxableAmount * $sgstPercent) / 100;
            $cgstAmount = ($taxableAmount * $cgstPercent) / 100;
            $totalWithGST = $taxableAmount + $sgstAmount + $cgstAmount;
            ?>
            GST <?php echo number_format($taxableAmount, 2); ?> * <?php echo ($sgstPercent + $cgstPercent); ?>% = 
            ₹<?php echo number_format($sgstAmount, 2); ?> SGST + ₹<?php echo number_format($cgstAmount, 2); ?> CGST
            <div style="margin-top: 2px;">" GET WELL SOON "</div>
        </div>

        <!-- Terms & Conditions -->
        <div class="footer-section">
            <div class="terms-conditions">
                <strong>Terms & Conditions</strong><br>
                Item will get exchanged within 16 days and will get returned on the same date only on presenting the original bill. 
                Damaged and opened items will not be taken back.<br>
                Please verify medicines from prescription by doctor before consume.
            </div>

            <div class="amount-in-words">
                <strong>Rupees <?php echo convertNumberToWords($order['grandTotalValue'] ?? $totalWithGST); ?> Only</strong>
            </div>

            <!-- Totals Section -->
            <div class="totals-section">
                <table style="width: 50%; margin-left: auto; border: none;">
                    <tr>
                        <td style="border: none; text-align: right;">SUB TOTAL</td>
                        <td style="border: none; text-align: right;">₹<?php echo number_format($taxableAmount, 2); ?></td>
                    </tr>
                    <tr>
                        <td style="border: none; text-align: right;">Discount @ Round off</td>
                        <td style="border: none; text-align: right;">₹<?php echo number_format($order['discount'] ?? 0, 2); ?></td>
                    </tr>
                    <tr>
                        <td style="border: none; text-align: right; border-top: 1px solid #000;"><strong>GRAND TOTAL</strong></td>
                        <td style="border: none; text-align: right; border-top: 1px solid #000;">
                            <strong>₹<?php echo number_format($order['grandTotalValue'] ?? $totalWithGST, 2); ?></strong>
                        </td>
                    </tr>
                </table>
            </div>

            <div class="signature-section">
                <div>For <?php echo $company['company'] ?? 'SHREE MEDICALS'; ?></div>
                <br>
                <div>Authorised Signatory</div>
            </div>
        </div>
    </div>

    <script>
        // Auto print if needed
        const urlParams = new URLSearchParams(window.location.search);
        if(urlParams.get('autoprint') === '1') {
            window.print();
        }
    </script>
</body>
</html>

<?php
// Function to convert number to words
function convertNumberToWords($number) {
    $hyphen      = '-';
    $conjunction = ' and ';
    $separator   = ', ';
    $negative    = 'negative ';
    $decimal     = ' point ';
    $dictionary  = array(
        0                   => 'zero',
        1                   => 'one',
        2                   => 'two',
        3                   => 'three',
        4                   => 'four',
        5                   => 'five',
        6                   => 'six',
        7                   => 'seven',
        8                   => 'eight',
        9                   => 'nine',
        10                  => 'ten',
        11                  => 'eleven',
        12                  => 'twelve',
        13                  => 'thirteen',
        14                  => 'fourteen',
        15                  => 'fifteen',
        16                  => 'sixteen',
        17                  => 'seventeen',
        18                  => 'eighteen',
        19                  => 'nineteen',
        20                  => 'twenty',
        30                  => 'thirty',
        40                  => 'forty',
        50                  => 'fifty',
        60                  => 'sixty',
        70                  => 'seventy',
        80                  => 'eighty',
        90                  => 'ninety',
        100                 => 'hundred',
        1000                => 'thousand',
        1000000             => 'million',
        1000000000          => 'billion',
        1000000000000       => 'trillion',
        1000000000000000    => 'quadrillion',
        1000000000000000000 => 'quintillion'
    );

    if (!is_numeric($number)) {
        return false;
    }

    if (($number >= 0 && (int) $number < 0) || (int) $number < 0 - PHP_INT_MAX) {
        trigger_error(
            'convertNumberToWords only accepts numbers between -' . PHP_INT_MAX . ' and ' . PHP_INT_MAX,
            E_USER_WARNING
        );
        return false;
    }

    if ($number < 0) {
        return $negative . convertNumberToWords(abs($number));
    }

    $string = $fraction = null;

    if (strpos($number, '.') !== false) {
        list($number, $fraction) = explode('.', $number);
    }

    switch (true) {
        case $number < 21:
            $string = $dictionary[$number];
            break;
        case $number < 100:
            $tens   = ((int) ($number / 10)) * 10;
            $units  = $number % 10;
            $string = $dictionary[$tens];
            if ($units) {
                $string .= $hyphen . $dictionary[$units];
            }
            break;
        case $number < 1000:
            $hundreds  = $number / 100;
            $remainder = $number % 100;
            $string = $dictionary[$hundreds] . ' ' . $dictionary[100];
            if ($remainder) {
                $string .= $conjunction . convertNumberToWords($remainder);
            }
            break;
        default:
            $baseUnit = pow(1000, floor(log($number, 1000)));
            $numBaseUnits = (int) ($number / $baseUnit);
            $remainder = $number % $baseUnit;
            $string = convertNumberToWords($numBaseUnits) . ' ' . $dictionary[$baseUnit];
            if ($remainder) {
                $string .= $remainder < 100 ? $conjunction : $separator;
                $string .= convertNumberToWords($remainder);
            }
            break;
    }

    if (null !== $fraction && is_numeric($fraction)) {
        $string .= $decimal;
        $words = array();
        foreach (str_split((string) $fraction) as $number) {
            $words[] = $dictionary[$number];
        }
        $string .= implode(' ', $words);
    }

    return ucwords($string);
}
?>