<?php include('./constant/layout/head.php');?>
<?php include('./constant/layout/header.php');?>
<?php include('./constant/layout/sidebar.php');?>

<div class="page-wrapper">
    <div class="row page-titles">
        <div class="col-md-5 align-self-center">
            <h3 class="text-primary">Ledger Report</h3> 
        </div>
    </div>
    
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table id="ledgerTable" class="table table-striped table-bordered">
                                <thead>
                                    <tr>
                                        <th>Date</th>
                                        <th>Invoice No</th>
                                        <th>Description</th>
                                        <th>Debit</th>
                                        <th>Credit</th>
                                        <th>Balance</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $ledgerSql = "SELECT l.*, o.uno as invoice_no 
                                                 FROM his_ledger l 
                                                 LEFT JOIN orders o ON l.order_id = o.id 
                                                 ORDER BY l.transaction_date DESC";
                                    $ledgerResult = $connect->query($ledgerSql);
                                    
                                    $balance = 0;
                                    while($row = $ledgerResult->fetch_assoc()) {
                                        $balance = $balance + $row['debit'] - $row['credit'];
                                        ?>
                                        <tr>
                                            <td><?php echo $row['transaction_date']; ?></td>
                                            <td><?php echo $row['invoice_no']; ?></td>
                                            <td><?php echo $row['description']; ?></td>
                                            <td><?php echo number_format($row['debit'], 2); ?></td>
                                            <td><?php echo number_format($row['credit'], 2); ?></td>
                                            <td><?php echo number_format($balance, 2); ?></td>
                                        </tr>
                                        <?php
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include('./constant/layout/footer.php');?>

<script>
$(document).ready(function() {
    $('#ledgerTable').DataTable({
        "order": [[0, "desc"]]
    });
});
</script>