<?php
// ini_set('display_errors', 1);
// ini_set('display_startup_errors', 1);
// error_reporting(E_ALL);

include('./constant/layout/head.php');
include('./constant/connect.php');
session_start();

// If user is already logged in, redirect to dashboard
if (isset($_SESSION['userId']) && !empty($_SESSION['userId'])) {
    header('Location: dashboard.php');
    exit();
}

$errors = array();
$login_error = '';
$login_success = false;

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $email = trim($_POST['email']);
    $password = trim($_POST['password']);

    // Validate input
    if (empty($email)) {
        $errors[] = "Email is required";
    }

    if (empty($password)) {
        $errors[] = "Password is required";
    }

    if (empty($errors)) {
        // Use prepared statement to prevent SQL injection
        $stmt = $connect->prepare("SELECT user_id, password FROM users WHERE email = ?");
        $stmt->bind_param("s", $email);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows === 1) {
            $user = $result->fetch_assoc();
            $hashed_password = $user['password'];

            // Check password (your DB uses md5)
            if ($hashed_password === md5($password)) {
                $_SESSION['userId'] = $user['user_id'];
                $login_success = true;
            } else {
                $login_error = "Incorrect email/password combination";
            }
        } else {
            $login_error = "Email does not exist";
        }

        $stmt->close();
    }
}
?>


<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login</title>
    <style>
        :root {
            --primary-color: #5c4ac7;
            --secondary-color: #102b49;
            --success-color: #4CAF50;
            --error-color: #F44336;
            --text-color: #333;
            --light-gray: #f5f5f5;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        body {
            background-color: #f9f9f9;
            color: var(--text-color);
        }
        
        .login-container {
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            padding: 20px;
        }
        
        .login-card {
            background: white;
            border-radius: 12px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
            width: 100%;
            max-width: 420px;
            overflow: hidden;
        }
        
        .login-header {
            background: lightblue;
            padding: 30px 20px;
            text-align: center;
        }
        
        .login-header img {
            max-width: 220px;
        }
        
        .login-form {
            padding: 30px;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 8px;
            font-weight: 600;
            color: var(--text-color);
        }
        
        .form-control {
            width: 100%;
            padding: 12px 15px;
            border: 1px solid #ddd;
            border-radius: 8px;
            font-size: 16px;
            transition: border 0.3s;
        }
        
        .form-control:focus {
            border-color: var(--primary-color);
            outline: none;
            box-shadow: 0 0 0 2px rgba(92, 74, 199, 0.2);
        }
        
        .form-options {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 25px;
        }
        
        .remember-me {
            display: flex;
            align-items: center;
        }
        
        .remember-me input {
            margin-right: 8px;
        }
        
        .forgot-password {
            color: var(--primary-color);
            text-decoration: none;
            font-weight: 500;
        }
        
        .forgot-password:hover {
            text-decoration: underline;
        }
        
        .login-button {
            background-color: var(--secondary-color);
            color: white;
            border: none;
            border-radius: 50px;
            padding: 14px 20px;
            width: 100%;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: background 0.3s;
        }
        
        .login-button:hover {
            background-color: var(--primary-color);
        }
        
        /* Toast notification styles */
        .toast-container {
            position: fixed;
            top: 20px;
            right: 20px;
            z-index: 9999;
        }
        
        .toast {
            background: white;
            border-radius: 8px;
            padding: 16px 20px;
            margin-bottom: 10px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
            display: flex;
            align-items: center;
            animation: toast-in-right 0.7s;
            position: relative;
            overflow: hidden;
        }
        
        .toast::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 6px;
            height: 100%;
        }
        
        .toast-success::before {
            background-color: var(--success-color);
        }
        
        .toast-error::before {
            background-color: var(--error-color);
        }
        
        .toast-icon {
            margin-right: 15px;
            font-size: 24px;
        }
        
        .toast-success .toast-icon {
            color: var(--success-color);
        }
        
        .toast-error .toast-icon {
            color: var(--error-color);
        }
        
        .toast-content {
            flex: 1;
        }
        
        .toast-title {
            font-weight: 600;
            margin-bottom: 5px;
        }
        
        .toast-message {
            font-size: 14px;
            color: #666;
        }
        
        .toast-close {
            background: none;
            border: none;
            font-size: 20px;
            cursor: pointer;
            color: #999;
            margin-left: 15px;
        }
        
        @keyframes toast-in-right {
            from {
                transform: translateX(100%);
            }
            to {
                transform: translateX(0);
            }
        }
        
        @media (max-width: 480px) {
            .login-card {
                max-width: 100%;
            }
            
            .login-form {
                padding: 20px;
            }
            
            .form-options {
                flex-direction: column;
                align-items: flex-start;
            }
            
            .forgot-password {
                margin-top: 10px;
            }
        }
    </style>
</head>
<body>
    <div class="login-container">
        <div class="login-card">
            <div class="login-header">
             <img src="<?php echo htmlspecialchars($settings['logo']); ?>" 
     alt="Company Logo" 
     style="width:100px; height:100px; border-radius:100%; object-fit:cover;">

            </div>
            
            <div class="login-form">
                <form action="<?php echo $_SERVER['PHP_SELF'] ?>" method="post" id="loginForm">
                    <div class="form-group">
                        <label for="email">Email</label>
                        <input type="email" name="email" id="email" class="form-control" placeholder="Email" pattern="[^@\s]+@[^@\s]+\.[^@\s]+" title="Invalid email address" required>
                    </div>
                    
                    <div class="form-group">
                        <label for="password">Password</label>
                        <input type="password" id="password" name="password" class="form-control" placeholder="Password" required>
                    </div>
                    
                    <div class="form-options">
                        <div class="remember-me">
                            <input type="checkbox" id="rememberMe">
                            <label for="rememberMe">Remember me</label>
                        </div>
                        
                        <a href="#" class="forgot-password">Forgot Password?</a>
                    </div>
                    
                    <button type="submit" name="login" class="login-button">Sign in</button>
                </form>
            </div>
        </div>
    </div>
    
    <div class="toast-container" id="toastContainer">
        <!-- Toast notifications will be inserted here -->
    </div>

    <script>
        // Function to show toast notification
        function showToast(type, title, message, duration = 5000) {
            const toastContainer = document.getElementById('toastContainer');
            
            const toast = document.createElement('div');
            toast.className = `toast toast-${type}`;
            
            const icon = type === 'success' ? '✓' : '✗';
            
            toast.innerHTML = `
                <div class="toast-icon">${icon}</div>
                <div class="toast-content">
                    <div class="toast-title">${title}</div>
                    <div class="toast-message">${message}</div>
                </div>
                <button class="toast-close">&times;</button>
            `;
            
            toastContainer.appendChild(toast);
            
            // Add event listener to close button
            const closeButton = toast.querySelector('.toast-close');
            closeButton.addEventListener('click', () => {
                toast.remove();
            });
            
            // Auto remove after duration
            if (duration) {
                setTimeout(() => {
                    if (toast.parentNode) {
                        toast.remove();
                    }
                }, duration);
            }
            
            return toast;
        }
        
        // Show toast notifications based on PHP variables
        <?php if (isset($login_success) && $login_success): ?>
            document.addEventListener('DOMContentLoaded', function() {
                showToast('success', 'Success', 'Login successful! Redirecting...', 1500);
                setTimeout(() => {
                    window.location.href = 'dashboard.php';
                }, 1500);
            });
        <?php elseif (isset($login_error)): ?>
            document.addEventListener('DOMContentLoaded', function() {
                showToast('error', 'Error', '<?php echo $login_error; ?>');
            });
        <?php endif; ?>
    </script>
    
    <!-- Include your existing scripts -->
    <script src="./assets/js/lib/jquery/jquery.min.js"></script>
    <script src="./assets/js/lib/bootstrap/js/popper.min.js"></script>
    <script src="./assets/js/lib/bootstrap/js/bootstrap.min.js"></script>
    <script src="./assets/js/jquery.slimscroll.js"></script>
    <script src="./assets/js/sidebarmenu.js"></script>
    <script src="./assets/js/lib/sticky-kit-master/dist/sticky-kit.min.js"></script>
    <script src="./assets/js/custom.min.js"></script>
</body>
</html>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login</title>
    <style>
        :root {
            --primary-color: #5c4ac7;
            --secondary-color: #102b49;
            --success-color: #4CAF50;
            --error-color: #F44336;
            --text-color: #333;
            --light-gray: #f5f5f5;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        body {
            background-color: #f9f9f9;
            color: var(--text-color);
        }
        
        .login-container {
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            padding: 20px;
        }
        
        .login-card {
            background: white;
            border-radius: 12px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
            width: 100%;
            max-width: 420px;
            overflow: hidden;
        }
        
        .login-header {
            background: lightblue;
            padding: 30px 20px;
            text-align: center;
        }
        
        .login-header img {
            max-width: 220px;
        }
        
        .login-form {
            padding: 30px;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 8px;
            font-weight: 600;
            color: var(--text-color);
        }
        
        .form-control {
            width: 100%;
            padding: 12px 15px;
            border: 1px solid #ddd;
            border-radius: 8px;
            font-size: 16px;
            transition: border 0.3s;
        }
        
        .form-control:focus {
            border-color: var(--primary-color);
            outline: none;
            box-shadow: 0 0 0 2px rgba(92, 74, 199, 0.2);
        }
        
        .form-options {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 25px;
        }
        
        .remember-me {
            display: flex;
            align-items: center;
        }
        
        .remember-me input {
            margin-right: 8px;
        }
        
        .forgot-password {
            color: var(--primary-color);
            text-decoration: none;
            font-weight: 500;
        }
        
        .forgot-password:hover {
            text-decoration: underline;
        }
        
        .login-button {
            background-color: var(--secondary-color);
            color: white;
            border: none;
            border-radius: 50px;
            padding: 14px 20px;
            width: 100%;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: background 0.3s;
        }
        
        .login-button:hover {
            background-color: var(--primary-color);
        }
        
        /* Toast notification styles */
        .toast-container {
            position: fixed;
            top: 20px;
            right: 20px;
            z-index: 9999;
        }
        
        .toast {
            background: white;
            border-radius: 8px;
            padding: 16px 20px;
            margin-bottom: 10px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
            display: flex;
            align-items: center;
            animation: toast-in-right 0.7s;
            position: relative;
            overflow: hidden;
        }
        
        .toast::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 6px;
            height: 100%;
        }
        
        .toast-success::before {
            background-color: var(--success-color);
        }
        
        .toast-error::before {
            background-color: var(--error-color);
        }
        
        .toast-icon {
            margin-right: 15px;
            font-size: 24px;
        }
        
        .toast-success .toast-icon {
            color: var(--success-color);
        }
        
        .toast-error .toast-icon {
            color: var(--error-color);
        }
        
        .toast-content {
            flex: 1;
        }
        
        .toast-title {
            font-weight: 600;
            margin-bottom: 5px;
        }
        
        .toast-message {
            font-size: 14px;
            color: #666;
        }
        
        .toast-close {
            background: none;
            border: none;
            font-size: 20px;
            cursor: pointer;
            color: #999;
            margin-left: 15px;
        }
        
        @keyframes toast-in-right {
            from {
                transform: translateX(100%);
            }
            to {
                transform: translateX(0);
            }
        }
        
        @media (max-width: 480px) {
            .login-card {
                max-width: 100%;
            }
            
            .login-form {
                padding: 20px;
            }
            
            .form-options {
                flex-direction: column;
                align-items: flex-start;
            }
            
            .forgot-password {
                margin-top: 10px;
            }
        }
    </style>
</head>
<body>
    <div class="login-container">
        <div class="login-card">
            <div class="login-header">
             <img src="<?php echo htmlspecialchars($settings['logo']); ?>" 
     alt="Company Logo" 
     style="width:100px; height:100px; border-radius:100%; object-fit:cover;">

            </div>
            
            <div class="login-form">
                <form action="<?php echo $_SERVER['PHP_SELF'] ?>" method="post" id="loginForm">
                    <div class="form-group">
                        <label for="email">Email</label>
                        <input type="email" name="email" id="email" class="form-control" placeholder="Email" pattern="[^@\s]+@[^@\s]+\.[^@\s]+" title="Invalid email address" required>
                    </div>
                    
                    <div class="form-group">
                        <label for="password">Password</label>
                        <input type="password" id="password" name="password" class="form-control" placeholder="Password" required>
                    </div>
                    
                    <div class="form-options">
                        <div class="remember-me">
                            <input type="checkbox" id="rememberMe">
                            <label for="rememberMe">Remember me</label>
                        </div>
                        
                        <a href="#" class="forgot-password">Forgot Password?</a>
                    </div>
                    
                    <button type="submit" name="login" class="login-button">Sign in</button>
                </form>
            </div>
        </div>
    </div>
    
    <div class="toast-container" id="toastContainer">
        <!-- Toast notifications will be inserted here -->
    </div>

    <script>
        // Function to show toast notification
        function showToast(type, title, message, duration = 5000) {
            const toastContainer = document.getElementById('toastContainer');
            
            const toast = document.createElement('div');
            toast.className = `toast toast-${type}`;
            
            const icon = type === 'success' ? '✓' : '✗';
            
            toast.innerHTML = `
                <div class="toast-icon">${icon}</div>
                <div class="toast-content">
                    <div class="toast-title">${title}</div>
                    <div class="toast-message">${message}</div>
                </div>
                <button class="toast-close">&times;</button>
            `;
            
            toastContainer.appendChild(toast);
            
            // Add event listener to close button
            const closeButton = toast.querySelector('.toast-close');
            closeButton.addEventListener('click', () => {
                toast.remove();
            });
            
            // Auto remove after duration
            if (duration) {
                setTimeout(() => {
                    if (toast.parentNode) {
                        toast.remove();
                    }
                }, duration);
            }
            
            return toast;
        }
        
        // Show toast notifications based on PHP variables
        <?php if (isset($login_success) && $login_success): ?>
            document.addEventListener('DOMContentLoaded', function() {
                showToast('success', 'Success', 'Login successful! Redirecting...', 1500);
                setTimeout(() => {
                    window.location.href = 'dashboard.php';
                }, 1500);
            });
        <?php elseif (isset($login_error)): ?>
            document.addEventListener('DOMContentLoaded', function() {
                showToast('error', 'Error', '<?php echo $login_error; ?>');
            });
        <?php endif; ?>
    </script>
    
    <!-- Include your existing scripts -->
    <script src="./assets/js/lib/jquery/jquery.min.js"></script>
    <script src="./assets/js/lib/bootstrap/js/popper.min.js"></script>
    <script src="./assets/js/lib/bootstrap/js/bootstrap.min.js"></script>
    <script src="./assets/js/jquery.slimscroll.js"></script>
    <script src="./assets/js/sidebarmenu.js"></script>
    <script src="./assets/js/lib/sticky-kit-master/dist/sticky-kit.min.js"></script>
    <script src="./assets/js/custom.min.js"></script>
</body>
</html>