<?php
require_once 'core.php';

header('Content-Type: application/json');

// Get form data with empty defaults (NOT hardcoded values)
$productName  = $_POST['productName'] ?? '';
$brandName    = $_POST['brandName'] ?? ''; // Empty default
$categoryName = $_POST['categoryName'] ?? '';
$productStatus= $_POST['productStatus'] ?? '';
$hsnCode      = $_POST['hsnCode'] ?? ''; // Empty default

// Validate required fields
if (empty($productName) || empty($categoryName) || empty($productStatus)) {
    echo json_encode(['status' => 'error', 'msg' => 'Please fill all required fields']);
    exit;
}

// Handle optional image upload
$image = null;
if (!empty($_FILES['Medicine']['name'])) {
    $image  = basename($_FILES['Medicine']['name']);
    $target = "../assets/myimages/" . $image;
    
    // Create directory if it doesn't exist
    if (!file_exists('../assets/myimages/')) {
        mkdir('../assets/myimages/', 0777, true);
    }
    
    if (!move_uploaded_file($_FILES['Medicine']['tmp_name'], $target)) {
        echo json_encode(['status' => 'error', 'msg' => 'Failed to upload image']);
        exit;
    }
}

$orderDate = date('Y-m-d');

// Prepare SQL with NULL values for optional fields
$sql = sprintf(
    "INSERT INTO product (product_name, product_image, brand_id, categories_id, added_date, active, status, hsn_code)
     VALUES ('%s', %s, %s, '%s', '%s', 1, '%s', %s)",
    $connect->real_escape_string($productName),
    $image ? "'" . $connect->real_escape_string($image) . "'" : "NULL",
    // Handle optional brand_id - set to NULL if empty
    !empty($brandName) ? "'" . $connect->real_escape_string($brandName) . "'" : "NULL",
    $connect->real_escape_string($categoryName),
    $orderDate,
    $connect->real_escape_string($productStatus),
    // Handle optional hsn_code - set to NULL if empty
    !empty($hsnCode) ? "'" . $connect->real_escape_string($hsnCode) . "'" : "NULL"
);

if ($connect->query($sql) === TRUE) {
    echo json_encode(['status' => 'success']);
} else {
    echo json_encode(['status' => 'error', 'msg' => $connect->error]);
}

$connect->close();
exit;
?>