<?php
include('../connect.php');

if(isset($_POST['order_id'])) {
    $order_id = $_POST['order_id'];
    
    $order_sql = "SELECT * FROM orders WHERE id = $order_id";
    $order_result = $connect->query($order_sql);
    $order = $order_result->fetch_assoc();
    
    $items_sql = "SELECT oi.*, p.product_name 
                  FROM order_item oi 
                  LEFT JOIN product p ON oi.productName = p.product_id 
                  WHERE oi.order_id = $order_id";
    $items_result = $connect->query($items_sql);
    
    // Create CSV content
    $csv = "Invoice No," . $order['uno'] . "\n";
    $csv .= "Invoice Date," . $order['orderDate'] . "\n";
    $csv .= "Client Name," . $order['clientName'] . "\n";
    $csv .= "Client Contact," . $order['clientContact'] . "\n";
    $csv .= "\n";
    
    // Add items header
    $csv .= "Product,Quantity,Rate,SGST %,CGST %,Discount %,Total\n";
    
    // Add items
    while($item = $items_result->fetch_assoc()) {
        $csv .= '"' . $item['product_name'] . '",';
        $csv .= $item['quantity'] . ',';
        $csv .= $item['rate'] . ',';
        $csv .= $item['sgst_percentage'] . ',';
        $csv .= $item['cgst_percentage'] . ',';
        $csv .= $item['discount_percentage'] . ',';
        $csv .= $item['total'] . "\n";
    }
    
    $csv .= "\n";
    
    // Add totals
    $csv .= "Sub Total,,,,,," . $order['subTotal'] . "\n";
    $csv .= "SGST Total,,,,,," . $order['sgst_total'] . "\n";
    $csv .= "CGST Total,,,,,," . $order['cgst_total'] . "\n";
    $csv .= "Discount %,,,,,," . $order['discount_percentage'] . "%\n";
    $csv .= "Grand Total,,,,,," . $order['grandTotalValue'] . "\n";
    $csv .= "Paid Amount,,,,,," . $order['paid'] . "\n";
    $csv .= "Due Amount,,,,,," . $order['dueValue'] . "\n";
    $csv .= "Payment Status,,,,,," . getPaymentStatus($order['paymentStatus']) . "\n";
    $csv .= "Payment Type,,,,,," . getPaymentType($order['paymentType']) . "\n";
    
    // Set headers
    header('Content-Type: text/csv');
    header('Content-Disposition: attachment;filename="Invoice_' . $order['uno'] . '.csv"');
    
    echo $csv;
    exit();
}

function getPaymentStatus($status) {
    $statuses = [1 => 'Full Payment', 2 => 'Advance Payment', 3 => 'No Payment'];
    return $statuses[$status] ?? 'Unknown';
}

function getPaymentType($type) {
    $types = [1 => 'Cheque', 2 => 'Cash', 3 => 'Credit Card', 4 => 'Phone Pe', 5 => 'Google Pay', 6 => 'Amazon Pay'];
    return $types[$type] ?? 'Unknown';
}
?>