<?php
require_once 'core.php';

$sql = "
    SELECT 
        p.product_id,
        p.product_name,
         p.expdate,
        c.column_number,
        c.row_no,
        CONCAT(c.column_number, '-', c.row_no) AS chamber, -- Combine column_number and row_no for chamber
        p.unit_description,
        p.rate,
        p.mrp,
        p.quantity,
        cat.categories_name
    FROM product p
    INNER JOIN categories cat ON p.categories_id = cat.categories_id
    INNER JOIN chambers c ON p.chamber = c.id -- Assuming p.chamber is a foreign key to chambers.id
    WHERE p.active = 1 AND p.status = 1 AND p.quantity != 0
";
$result = $connect->query($sql);

$output = [];
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $output[] = [
            'product_id' => $row['product_id'],
            'product_name' => $row['product_name'],
            'chamber' => $row['chamber'], // Now from chambers table
            'unit_description' => $row['unit_description'],
            'rate' => $row['rate'],
            'mrp' => $row['mrp'],
            'quantity' => $row['quantity'],
            'categories_name' => $row['categories_name'],
              'expiry' => $row['expdate']
            
        ];
    }
}

$connect->close();
echo json_encode($output);
?>