<?php
include('../connect.php');

if(isset($_POST['order_id'])) {
    $order_id = $_POST['order_id'];
    
    $order_sql = "SELECT * FROM orders WHERE id = $order_id";
    $order_result = $connect->query($order_sql);
    $order = $order_result->fetch_assoc();
    
    $items_sql = "SELECT oi.*, p.product_name 
                  FROM order_item oi 
                  LEFT JOIN product p ON oi.productName = p.product_id 
                  WHERE oi.order_id = $order_id";
    $items_result = $connect->query($items_sql);
    
    echo '
    <div class="invoice-print">
        <div class="text-center mb-4">
            <h2>TAX INVOICE</h2>
            <h3>'.$order['uno'].'</h3>
        </div>
        
        <div class="row mb-4">
            <div class="col-md-6">
                <strong>Client:</strong> '.$order['clientName'].'<br>
                <strong>Contact:</strong> '.$order['clientContact'].'<br>
                <strong>Date:</strong> '.date('d M Y', strtotime($order['orderDate'])).'
            </div>
            <div class="col-md-6 text-right">
                <strong>Grand Total:</strong> ₹'.number_format($order['grandTotalValue'], 2).'<br>
                <strong>Paid:</strong> ₹'.number_format($order['paid'], 2).'<br>
                <strong>Due:</strong> ₹'.number_format($order['dueValue'], 2).'
            </div>
        </div>
        
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>Product</th>
                    <th>Qty</th>
                    <th>Rate</th>
                    <th>SGST</th>
                    <th>CGST</th>
                    <th>Total</th>
                </tr>
            </thead>
            <tbody>';
            
            while($item = $items_result->fetch_assoc()) {
                echo '<tr>
                    <td>'.$item['product_name'].'</td>
                    <td>'.$item['quantity'].'</td>
                    <td>₹'.number_format($item['rate'], 2).'</td>
                    <td>'.$item['sgst_percentage'].'%</td>
                    <td>'.$item['cgst_percentage'].'%</td>
                    <td>₹'.number_format($item['total'], 2).'</td>
                </tr>';
            }
            
            echo '</tbody>
        </table>
        
        <div class="row mt-4">
            <div class="col-md-6">
                <strong>Payment Status:</strong> '.getPaymentStatus($order['paymentStatus']).'<br>
                <strong>Payment Type:</strong> '.getPaymentType($order['paymentType']).'
            </div>
            <div class="col-md-6 text-right">
                <strong>Sub Total:</strong> ₹'.number_format($order['subTotal'], 2).'<br>
                <strong>SGST:</strong> ₹'.number_format($order['sgst_total'], 2).'<br>
                <strong>CGST:</strong> ₹'.number_format($order['cgst_total'], 2).'<br>
                <strong>Discount:</strong> '.$order['discount_percentage'].'%<br>
                <h4>Grand Total: ₹'.number_format($order['grandTotalValue'], 2).'</h4>
            </div>
        </div>
        
        <div class="mt-5 text-center">
            <p>Thank you for your business!</p>
            <p>Generated on: '.date('d M Y H:i:s').'</p>
        </div>
    </div>';
}

function getPaymentStatus($status) {
    $statuses = [1 => 'Full Payment', 2 => 'Advance Payment', 3 => 'No Payment'];
    return $statuses[$status] ?? 'Unknown';
}

function getPaymentType($type) {
    $types = [1 => 'Cheque', 2 => 'Cash', 3 => 'Credit Card', 4 => 'Phone Pe', 5 => 'Google Pay', 6 => 'Amazon Pay'];
    return $types[$type] ?? 'Unknown';
}
?>