<?php
// php_action/wholesale_order.php
require_once '../constant/connect.php';

$response = array('success' => false, 'messages' => array());

if ($_POST) {
    // Get form data
    $invoice_no = $_POST['invoice_no'];
    $invoice_date = $_POST['invoice_date'];
    $invoice_time = $_POST['invoice_time'];
    $vendor_name = $_POST['vendor_name'];
    $vendor_contact = $_POST['vendor_contact'];
    $vendor_gstn = $_POST['vendor_gstn'];
    $sub_total = $_POST['sub_total_value'];
    $total_amount = $_POST['total_amount_value'];
    $discount_percentage = $_POST['discount_percentage'];
    $grand_total = $_POST['grand_total_value'];
    $paid_amount = $_POST['paid_amount'];
    $due_amount = $_POST['due_amount_value'];
    $payment_type = $_POST['payment_type'];
    $payment_status = $_POST['payment_status'];
    $sgst_total = $_POST['sgst_total_value'];
    $cgst_total = $_POST['cgst_total_value'];

    // Start transaction
    $connect->autocommit(FALSE);
    
    try {
        // Insert wholesale order
        $orderSql = "INSERT INTO wholesale_orders (
            invoice_no, invoice_date, vendor_name, vendor_contact, vendor_gstn,
            sub_total, total_amount, discount_percentage, grand_total,
            paid_amount, due_amount, payment_type, payment_status,
            sgst_total, cgst_total
        ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        
        $orderStmt = $connect->prepare($orderSql);
        $orderStmt->bind_param("ssssssdddddiidd", 
            $invoice_no, $invoice_date, $vendor_name, $vendor_contact, $vendor_gstn,
            $sub_total, $total_amount, $discount_percentage, $grand_total,
            $paid_amount, $due_amount, $payment_type, $payment_status,
            $sgst_total, $cgst_total
        );
        
        if (!$orderStmt->execute()) {
            throw new Exception("Error creating wholesale order: " . $orderStmt->error);
        }
        
        $wholesale_order_id = $connect->insert_id;
        
        // Insert order items
        if (isset($_POST['productName'])) {
            $productSql = "INSERT INTO wholesale_order_items (
                wholesale_order_id, product_id, product_name, quantity, unit_price,
                total_price, sgst_percentage, cgst_percentage, discount_percentage
            ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
            
            $productStmt = $connect->prepare($productSql);
            
            for ($x = 0; $x < count($_POST['productName']); $x++) {
                $product_id = $_POST['productName'][$x];
                $quantity = $_POST['quantity'][$x];
                $unit_price = $_POST['unit_price_value'][$x];
                $total_price = $_POST['total_value'][$x];
                $sgst_percentage = $_POST['sgst_percentage'][$x];
                $cgst_percentage = $_POST['cgst_percentage'][$x];
                $discount_percentage_item = $_POST['discount_percentage_item'][$x];
                
                // Get product name
                $productNameQuery = "SELECT product_name FROM product WHERE product_id = ?";
                $productNameStmt = $connect->prepare($productNameQuery);
                $productNameStmt->bind_param("i", $product_id);
                $productNameStmt->execute();
                $productNameResult = $productNameStmt->get_result();
                $productNameRow = $productNameResult->fetch_assoc();
                $product_name = $productNameRow['product_name'];
                
                $productStmt->bind_param("iisiddddd", 
                    $wholesale_order_id, $product_id, $product_name, $quantity, $unit_price,
                    $total_price, $sgst_percentage, $cgst_percentage, $discount_percentage_item
                );
                
                if (!$productStmt->execute()) {
                    throw new Exception("Error adding product: " . $productStmt->error);
                }
                
                // Update product quantity (reduce stock for wholesale)
                $updateQuantitySql = "UPDATE product SET quantity = quantity - ? WHERE product_id = ?";
                $updateStmt = $connect->prepare($updateQuantitySql);
                $updateStmt->bind_param("ii", $quantity, $product_id);
                
                if (!$updateStmt->execute()) {
                    throw new Exception("Error updating product quantity: " . $updateStmt->error);
                }
            }
        }
        
        // Commit transaction
        $connect->commit();
        $response['success'] = true;
        $response['messages'] = "Wholesale invoice created successfully!";
        
    } catch (Exception $e) {
        // Rollback transaction on error
        $connect->rollback();
        $response['success'] = false;
        $response['messages'] = $e->getMessage();
    }
    
    $connect->autocommit(TRUE);
} else {
    $response['success'] = false;
    $response['messages'] = "No data received";
}

echo json_encode($response);
?>