
<?php
error_reporting(E_ALL);
ini_set('display_errors', 1); // Enable error display for debugging
include('./constant/layout/head.php');
include('./constant/layout/header.php');
include('./constant/layout/sidebar.php');
include('./constant/connect.php');

/* --- PAGINATION SETTINGS --- */
$limit = 10; // number of rows per page
$page = isset($_GET['page']) && is_numeric($_GET['page']) ? (int)$_GET['page'] : 1;
$start = ($page - 1) * $limit;

/* --- COUNT TOTAL ROWS --- */
$countSql = "SELECT COUNT(*) AS total 
             FROM product p 
             WHERE p.status = 1 AND p.active = 1";
$countResult = $connect->query($countSql);
if (!$countResult) {
    die("Count query failed: " . $connect->error);
}
$totalRows = $countResult->fetch_assoc()['total'];
$totalPages = ceil($totalRows / $limit);

/* --- MAIN QUERY WITH LIMIT --- */
$sql = "
SELECT 
    p.*,
    COALESCE(b.brand_name, 'N/A') AS brand_name,
    COALESCE(c.categories_name, 'N/A') AS categories_name,
    COALESCE(s.supplier_name, 'N/A') AS supplier_name,
    COALESCE(ch.column_number, 'N/A') AS column_number,
    COALESCE(ch.row_no, 'N/A') AS row_no
FROM product p
LEFT JOIN brands b ON p.brand_id = b.brand_id
LEFT JOIN categories c ON p.categories_id = c.categories_id
LEFT JOIN suppliers s ON p.supplier_id = s.supplier_id
LEFT JOIN chambers ch ON p.chamber = ch.id
WHERE p.status = 1 AND p.active = 1
ORDER BY p.product_name
LIMIT $start, $limit
";
$result = $connect->query($sql);
if (!$result) {
    die("Main query failed: " . $connect->error);
}
?>

<div class="page-wrapper">
    <div class="row page-titles">
        <div class="col-md-5 align-self-center">
            <h3 class="text-primary">View Products</h3>
        </div>
        <div class="col-md-7 align-self-center">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="#">Home</a></li>
                <li class="breadcrumb-item active">View Products</li>
            </ol>
        </div>
    </div>

    <div class="container-fluid">
        <div class="card soft-card">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <a href="add-product.php" class="btn btn-primary soft-btn">
                        <i class="fa fa-plus"></i> Add Product
                    </a>
                    <div class="form-group mb-0 position-relative" style="max-width:300px;">
                        <input type="text" id="searchProduct" class="form-control soft-input" placeholder="Search medicines...">
                        <div id="loadingSpinner" class="spinner-border spinner-border-sm text-primary" style="display: none; position: absolute; right: 10px; top: 50%; transform: translateY(-50%);"></div>
                    </div>
                </div>

                <div class="table-responsive m-t-40">
                    <table id="productTable" class="table table-bordered table-hover soft-table">
                        <thead class="table-dark text-white">
                            <tr>
                                <th>#</th>
                                <th>Product Name</th>
                                <th>HSN Code</th>
                                <th>Manufacturer</th>
                                <th>Category</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody id="productTableBody">
                        <?php 
                        $counter = $start + 1;
                        if ($result && $result->num_rows > 0):
                            while($row = $result->fetch_assoc()): 
                                $expiry_class = '';
                                $today = new DateTime();
                                $expiry_date = !empty($row['expdate']) ? new DateTime($row['expdate']) : null;
                                if ($expiry_date && $expiry_date < $today) {
                                    $expiry_class = 'text-danger';
                                } elseif ($expiry_date && $expiry_date->diff($today)->days < 30) {
                                    $expiry_class = 'text-warning';
                                }
                        ?>
                        <tr>
                            <td class="text-center"><?php echo $counter++; ?></td>
                            <td>
                                <div class="d-flex align-items-center">
                                    <div class="mr-3">
                                        <?php if(!empty($row['product_image']) && file_exists('assets/myimages/'.$row['product_image'])): ?>
                                            <img src="assets/myimages/<?php echo htmlspecialchars($row['product_image']); ?>" 
                                                 style="width:60px; height:60px; border-radius:8px; object-fit:cover;" 
                                                 alt="<?php echo htmlspecialchars($row['product_name']); ?>">
                                        <?php else: ?>
                                            <div style="width:60px; height:60px; border-radius:8px; background:#f0f4f8; display:flex; align-items:center; justify-content:center;">
                                                <i class="fa fa-pills" style="font-size:20px; color:#4a6cf7;"></i>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                    <div>
                                        <strong class="d-block"><?php echo htmlspecialchars($row['product_name']); ?></strong>
                                        <small class="text-muted">
                                            <?php if(!empty($row['bno'])): ?>
                                                Batch: <?php echo htmlspecialchars($row['bno']); ?>
                                            <?php endif; ?>
                                        </small>
                                    </div>
                                </div>
                            </td>
                            <td>
                                <div class="text-center">
                                    <?php if(!empty($row['hsn_code'])): ?>
                                        <span class="badge badge-light"><?php echo htmlspecialchars($row['hsn_code']); ?></span>
                                    <?php else: ?>
                                        <span class="text-muted">N/A</span>
                                    <?php endif; ?>
                                </div>
                            </td>
                            <td>
                                <div class="manufacturer-info">
                                    <strong><?php echo htmlspecialchars($row['brand_name']); ?></strong>
                                    <?php if(!empty($row['supplier_name']) && $row['supplier_name'] != 'N/A'): ?>
                                        <br><small class="text-muted">Supplier: <?php echo htmlspecialchars($row['supplier_name']); ?></small>
                                    <?php endif; ?>
                                </div>
                            </td>
                            <td>
                                <div class="category-info">
                                    <span class="badge badge-info"><?php echo htmlspecialchars($row['categories_name']); ?></span>
                                    <?php if(!empty($row['row_no']) && $row['row_no'] != 'N/A'): ?>
                                        <br><small class="text-muted">Storage: <?php echo htmlspecialchars($row['row_no']. ' , '.$row['column_number']); ?></small>
                                    <?php endif; ?>
                                </div>
                            </td>
                            <td class="text-center">
                                <span class="badge soft-badge <?php echo $row['active'] == 1 ? 'badge-success' : 'badge-secondary'; ?>">
                                    <?php echo ($row['active'] == 1) ? 'Available' : 'Not Available'; ?>
                                </span>
                                <div class="stock-info mt-1">
                                    <small class="<?php echo $row['quantity'] < 10 ? 'text-danger' : 'text-muted'; ?>">
                                        Stock: <?php echo htmlspecialchars($row['quantity']); ?> <?php echo !empty($row['unit']) ? htmlspecialchars($row['unit']) : 'Pcs'; ?>
                                    </small>
                                </div>
                            </td>
                            <td>
                                <div class="btn-group-vertical">
                                    <button class="btn btn-sm btn-warning mb-1" onclick="editProduct(<?php echo $row['product_id']; ?>)" title="Edit Medicine">
                                        <i class="fas fa-edit"></i> Edit
                                    </button>
                                    <button class="btn btn-sm btn-danger" onclick="deleteProduct(<?php echo $row['product_id']; ?>)" title="Delete Medicine">
                                        <i class="fas fa-trash"></i> Delete
                                    </button>
                                </div>
                            </td>
                        </tr>
                        <?php 
                            endwhile;
                        else: 
                        ?>
                        <tr>
                            <td colspan="7" class="text-center py-4">
                                <div class="text-muted">
                                    <i class="fa fa-pills fa-3x mb-3"></i>
                                    <h5>No Product found</h5>
                                    <p>Add your first Product to get started</p>
                                    <a href="add-product.php" class="btn btn-primary soft-btn">
                                        <i class="fa fa-plus"></i> Add Product
                                    </a>
                                </div>
                            </td>
                        </tr>
                        <?php endif; ?>
                        </tbody>
                    </table>
                </div>

                <!-- PAGINATION LINKS -->
                <nav id="pagination">
                    <?php if ($totalPages > 1): ?>
                    <ul class="pagination justify-content-center">
                        <?php for ($i = 1; $i <= $totalPages; $i++): ?>
                            <li class="page-item <?php echo ($i == $page) ? 'active' : ''; ?>">
                                <a class="page-link" href="?page=<?php echo $i; ?>"><?php echo $i; ?></a>
                            </li>
                        <?php endfor; ?>
                    </ul>
                    <?php endif; ?>
                </nav>
            </div>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    let searchTimeout;
    $('#searchProduct').on('input', function() {
        clearTimeout(searchTimeout);
        const searchTerm = $(this).val().trim();
        const page = <?php echo $page; ?>;
        
        $('#loadingSpinner').show();
        
        // Delay search to prevent rapid requests
        searchTimeout = setTimeout(function() {
            $.ajax({
                url: 'searchProducts.php',
                method: 'POST',
                data: { search: searchTerm, page: page },
                dataType: 'json',
                success: function(response) {
                    $('#loadingSpinner').hide();
                    if (response.success) {
                        $('#productTableBody').html(response.table);
                        $('#pagination').html(response.pagination);
                    } else {
                        $('#productTableBody').html(`
                            <tr>
                                <td colspan="7" class="text-center py-4">
                                    <div class="text-muted">
                                        <i class="fa fa-pills fa-3x mb-3"></i>
                                        <h5>No Products Found</h5>
                                        <p>No products match your search criteria.</p>
                                    </div>
                                </td>
                            </tr>
                        `);
                        $('#pagination').empty();
                    }
                },
                error: function(xhr, status, error) {
                    $('#loadingSpinner').hide();
                    console.error('Search error:', status, error, xhr.responseText);
                    alert('Error performing search: ' + (xhr.responseText || 'Unknown error. Check server logs.'));
                }
            });
        }, 300); // 300ms debounce
    });

    // Handle pagination clicks
    $(document).on('click', '.page-link', function(e) {
        e.preventDefault();
        const page = $(this).attr('href').split('page=')[1];
        const searchTerm = $('#searchProduct').val().trim();
        
        $('#loadingSpinner').show();
        $.ajax({
            url: 'searchProducts.php',
            method: 'POST',
            data: { search: searchTerm, page: page },
            dataType: 'json',
            success: function(response) {
                $('#loadingSpinner').hide();
                if (response.success) {
                    $('#productTableBody').html(response.table);
                    $('#pagination').html(response.pagination);
                }
            },
            error: function(xhr, status, error) {
                $('#loadingSpinner').hide();
                console.error('Pagination error:', status, error, xhr.responseText);
                alert('Error loading page: ' + (xhr.responseText || 'Unknown error. Check server logs.'));
            }
        });
    });
});

function editProduct(productId) {
    window.location.href = 'editproduct.php?id=' + productId;
}

function deleteProduct(productId) {
    if (confirm('Are you sure you want to delete this medicine?')) {
        window.location.href = 'php_action/removeProduct.php?id=' + productId;
    }
}
</script>

<style>
/* Existing styles from original code */
.soft-card {
    border-radius: 15px;
    box-shadow: 0 8px 25px rgba(0,0,0,0.1);
    transition: all 0.3s ease;
}
.soft-card:hover {
    transform: translateY(-3px);
}
.soft-table th {
    background: linear-gradient(135deg, #667eea, #764ba2);
    color: #fff;
}
.soft-btn {
    background: linear-gradient(135deg, #667eea, #764ba2);
    border: none;
    border-radius: 8px;
    color: #fff;
}
.soft-btn:hover {
    background: linear-gradient(135deg, #556cd6, #643c9e);
}
.soft-input {
    border-radius: 12px;
    padding: 10px;
}
.soft-badge {
    padding: 6px 12px;
    border-radius: 20px;
}
.badge-success {
    background: linear-gradient(135deg, #28a745, #34ce57);
}
.badge-secondary {
    background: #6c757d;
}
.btn-warning {
    background: linear-gradient(135deg, #ffc107, #ffca2c);
}
.btn-danger {
    background: linear-gradient(135deg, #dc3545, #f66);
}

/* Additional styles for search */
#loadingSpinner {
    z-index: 1000;
}
.table-responsive {
    min-height: 200px;
}
</style>

<?php include('./constant/layout/footer.php'); ?>
