<?php include('./constant/layout/head.php'); ?>
<?php include('./constant/layout/header.php'); ?>
<?php include('./constant/layout/sidebar.php'); ?>
<?php include('../constant/connect.php'); ?>

<?php
// Load current settings
$settings = $connect->query("SELECT * FROM system_settings LIMIT 1")->fetch_assoc();

if($_POST) {
    $system_name = $_POST['system_name'];
    $title = $_POST['title'];
    $footer = $_POST['footer'];
    $phone = $_POST['phone'];
    $email = $_POST['email'];
    $company = $_POST['company'];
    $url = $_POST['url'];

    // Handle logo upload
    $logo = @$settings['logo'];
    if(isset($_FILES['logo']) && $_FILES['logo']['name'] != '') {
        $targetDir = "uploads/";
        if(!is_dir($targetDir)) mkdir($targetDir, 0777, true);
        $logoFile = $targetDir . basename($_FILES['logo']['name']);
        if(move_uploaded_file($_FILES['logo']['tmp_name'], $logoFile)) {
            $logo = $logoFile;
        }
    }

    if($settings) {
        $connect->query("UPDATE system_settings SET 
            system_name='$system_name',
            title='$title',
            footer='$footer',
            phone='$phone',
            email='$email',
            company='$company',
            url='$url',
            logo='$logo'
        ");
    } else {
        $connect->query("INSERT INTO system_settings (system_name, title, footer, phone, email, company, url, logo) VALUES 
        ('$system_name','$title','$footer','$phone','$email','$company','$url','$logo')");
    }
    echo '<div class="alert alert-success alert-modern">Settings saved successfully!</div>';
}
?>

<div class="page-wrapper">
    <div class="row page-titles">
        <div class="col-md-5 align-self-center">
            <h3 class="text-primary"><i class="fas fa-cog me-2"></i>System Configuration</h3>
        </div>
        <div class="col-md-7 align-self-center">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="javascript:void(0)">Home</a></li>
                <li class="breadcrumb-item active">System Settings</li>
            </ol>
        </div>
    </div>

    <div class="container-fluid">
        <!-- Settings Cards -->
        <div class="row">
            <!-- System Info Card -->
            <div class="col-lg-8">
                <div class="card card-modern">
                    <div class="card-header card-header-modern">
                        <h4 class="card-title"><i class="fas fa-info-circle me-2"></i>System Information</h4>
                        <p class="card-subtitle">Update your system details and branding</p>
                    </div>
                    <div class="card-body">
                        <form method="post" class="form-modern" enctype="multipart/form-data">
                            <!-- Logo Section -->
                            <div class="setting-section">
                                <h5 class="section-title"><i class="fas fa-image me-2"></i>Branding</h5>
                                <div class="logo-preview-container text-center mb-4">
                                    <?php if(@$settings['logo'] != ''): ?>
                                        <img src="<?php echo $settings['logo']; ?>" alt="System Logo" class="logo-preview">
                                    <?php else: ?>
                                        <div class="logo-placeholder">
                                            <i class="fas fa-camera"></i>
                                            <p>No logo uploaded</p>
                                        </div>
                                    <?php endif; ?>
                                </div>
                                <div class="form-group-modern">
                                    <label class="form-label">Upload Logo</label>
                                    <div class="file-upload-wrapper">
                                        <input type="file" name="logo" class="file-upload-input" id="logoUpload">
                                        <label for="logoUpload" class="file-upload-label">
                                            <i class="fas fa-cloud-upload-alt me-2"></i>Choose File
                                        </label>
                                        <span class="file-upload-name" id="fileName">No file chosen</span>
                                    </div>
                                </div>
                            </div>

                            <!-- System Details -->
                            <div class="setting-section">
                                <h5 class="section-title"><i class="fas fa-sliders-h me-2"></i>System Details</h5>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group-modern">
                                            <label class="form-label">System Name</label>
                                            <div class="input-with-icon">
                                                <i class="fas fa-signature"></i>
                                                <input type="text" name="system_name" class="form-control-modern" value="<?php echo @$settings['system_name']; ?>" placeholder="Enter system name" />
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group-modern">
                                            <label class="form-label">Title</label>
                                            <div class="input-with-icon">
                                                <i class="fas fa-heading"></i>
                                                <input type="text" name="title" class="form-control-modern" value="<?php echo @$settings['title']; ?>" placeholder="Enter page title" />
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group-modern">
                                    <label class="form-label">Footer Text</label>
                                    <div class="input-with-icon">
                                        <i class="fas fa-text-height"></i>
                                        <input type="text" name="footer" class="form-control-modern" value="<?php echo @$settings['footer']; ?>" placeholder="Enter footer text" />
                                    </div>
                                </div>
                            </div>

                            <!-- Contact Information -->
                            <div class="setting-section">
                                <h5 class="section-title"><i class="fas fa-address-card me-2"></i>Contact Information</h5>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group-modern">
                                            <label class="form-label">Phone</label>
                                            <div class="input-with-icon">
                                                <i class="fas fa-phone"></i>
                                                <input type="text" name="phone" class="form-control-modern" value="<?php echo @$settings['phone']; ?>" placeholder="Enter phone number" />
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group-modern">
                                            <label class="form-label">Email</label>
                                            <div class="input-with-icon">
                                                <i class="fas fa-envelope"></i>
                                                <input type="email" name="email" class="form-control-modern" value="<?php echo @$settings['email']; ?>" placeholder="Enter email address" />
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group-modern">
                                            <label class="form-label">Company</label>
                                            <div class="input-with-icon">
                                                <i class="fas fa-building"></i>
                                                <input type="text" name="company" class="form-control-modern" value="<?php echo @$settings['company']; ?>" placeholder="Enter company name" />
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group-modern">
                                            <label class="form-label">Website URL</label>
                                            <div class="input-with-icon">
                                                <i class="fas fa-globe"></i>
                                                <input type="text" name="url" class="form-control-modern" value="<?php echo @$settings['url']; ?>" placeholder="Enter website URL" />
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="form-actions">
                                <button type="submit" class="btn btn-primary-modern">
                                    <i class="fas fa-save me-2"></i>Save Settings
                                </button>
                                <button type="reset" class="btn btn-secondary-modern">
                                    <i class="fas fa-undo me-2"></i>Reset
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            <!-- Server Info Card -->
            <div class="col-lg-4">
                <div class="card card-modern">
                    <div class="card-header card-header-modern">
                        <h4 class="card-title"><i class="fas fa-server me-2"></i>Server Information</h4>
                        <p class="card-subtitle">Current server environment details</p>
                    </div>
                    <div class="card-body">
                        <div class="server-info-list">
                            <div class="info-item">
                                <div class="info-icon">
                                    <i class="fab fa-php"></i>
                                </div>
                                <div class="info-content">
                                    <h6>PHP Version</h6>
                                    <p><?php echo phpversion(); ?></p>
                                </div>
                            </div>
                            <div class="info-item">
                                <div class="info-icon">
                                    <i class="fas fa-database"></i>
                                </div>
                                <div class="info-content">
                                    <h6>MySQL Version</h6>
                                    <p><?php echo $connect->server_info; ?></p>
                                </div>
                            </div>
                            <div class="info-item">
                                <div class="info-icon">
                                    <i class="fas fa-desktop"></i>
                                </div>
                                <div class="info-content">
                                    <h6>Server OS</h6>
                                    <p><?php echo PHP_OS; ?></p>
                                </div>
                            </div>
                            <div class="info-item">
                                <div class="info-icon">
                                    <i class="fas fa-code"></i>
                                </div>
                                <div class="info-content">
                                    <h6>Server Software</h6>
                                    <p><?php echo $_SERVER['SERVER_SOFTWARE']; ?></p>
                                </div>
                            </div>
                            <div class="info-item">
                                <div class="info-icon">
                                    <i class="fas fa-folder"></i>
                                </div>
                                <div class="info-content">
                                    <h6>Document Root</h6>
                                    <p class="text-truncate"><?php echo $_SERVER['DOCUMENT_ROOT']; ?></p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Quick Stats Card -->
                <div class="card card-modern mt-4">
                    <div class="card-header card-header-modern">
                        <h4 class="card-title"><i class="fas fa-chart-bar me-2"></i>Quick Stats</h4>
                    </div>
                    <div class="card-body">
                        <div class="stats-grid">
                            <div class="stat-box">
                                <div class="stat-icon stat-primary">
                                    <i class="fas fa-users"></i>
                                </div>
                                <div class="stat-info">
                                    <h3>256</h3>
                                    <p>Users</p>
                                </div>
                            </div>
                            <div class="stat-box">
                                <div class="stat-icon stat-success">
                                    <i class="fas fa-shopping-cart"></i>
                                </div>
                                <div class="stat-info">
                                    <h3>1,024</h3>
                                    <p>Orders</p>
                                </div>
                            </div>
                            <div class="stat-box">
                                <div class="stat-icon stat-info">
                                    <i class="fas fa-box"></i>
                                </div>
                                <div class="stat-info">
                                    <h3>78</h3>
                                    <p>Products</p>
                                </div>
                            </div>
                            <div class="stat-box">
                                <div class="stat-icon stat-warning">
                                    <i class="fas fa-truck"></i>
                                </div>
                                <div class="stat-info">
                                    <h3>42</h3>
                                    <p>Suppliers</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
/* Modern Design System */
:root {
    --primary: #4361ee;
    --primary-light: #4895ef;
    --secondary: #3f37c9;
    --success: #4cc9f0;
    --danger: #f72585;
    --warning: #f8961e;
    --info: #560bad;
    --dark: #212529;
    --light: #f8f9fa;
    --gray: #6c757d;
    --border: #dee2e6;
    --card-shadow: 0 5px 20px rgba(0, 0, 0, 0.08);
    --transition: all 0.3s ease;
}

/* Modern Card */
.card-modern {
    border: none;
    border-radius: 12px;
    box-shadow: var(--card-shadow);
    transition: var(--transition);
    margin-bottom: 24px;
}

.card-modern:hover {
    box-shadow: 0 8px 25px rgba(0, 0, 0, 0.12);
}

.card-header-modern {
    background: linear-gradient(120deg, #f8f9fa 0%, #ffffff 100%);
    border-bottom: 1px solid var(--border);
    padding: 20px 25px;
    border-radius: 12px 12px 0 0 !important;
}

.card-header-modern .card-title {
    font-weight: 600;
    color: var(--dark);
    margin-bottom: 5px;
}

.card-header-modern .card-subtitle {
    color: var(--gray);
    font-size: 0.875rem;
    margin: 0;
}

/* Form Elements */
.form-modern {
    padding: 0 5px;
}

.setting-section {
    padding: 20px 0;
    border-bottom: 1px solid var(--border);
}

.setting-section:last-child {
    border-bottom: none;
}

.section-title {
    font-weight: 600;
    color: var(--dark);
    margin-bottom: 20px;
    font-size: 1.1rem;
}

.form-group-modern {
    margin-bottom: 20px;
}

.form-label {
    font-weight: 500;
    color: var(--dark);
    margin-bottom: 8px;
    display: block;
}

.input-with-icon {
    position: relative;
}

.input-with-icon i {
    position: absolute;
    left: 15px;
    top: 50%;
    transform: translateY(-50%);
    color: var(--gray);
    z-index: 1;
}

.form-control-modern {
    width: 100%;
    padding: 12px 15px 12px 45px;
    border: 1px solid var(--border);
    border-radius: 8px;
    background-color: #fff;
    transition: var(--transition);
    font-size: 0.95rem;
}

.form-control-modern:focus {
    border-color: var(--primary);
    box-shadow: 0 0 0 3px rgba(67, 97, 238, 0.15);
    outline: none;
}

/* File Upload */
.file-upload-wrapper {
    position: relative;
}

.file-upload-input {
    position: absolute;
    left: -9999px;
}

.file-upload-label {
    display: inline-block;
    padding: 10px 20px;
    background: var(--light);
    color: var(--dark);
    border-radius: 8px;
    cursor: pointer;
    transition: var(--transition);
    border: 1px dashed var(--border);
    text-align: center;
    margin-right: 10px;
}

.file-upload-label:hover {
    background: #e9ecef;
}

.file-upload-name {
    color: var(--gray);
    font-size: 0.9rem;
}

/* Logo Preview */
.logo-preview-container {
    padding: 20px;
    border: 2px dashed var(--border);
    border-radius: 8px;
    background: var(--light);
    margin-bottom: 20px;
}

.logo-preview {
    max-height: 100px;
    max-width: 100%;
    border-radius: 6px;
}

.logo-placeholder {
    color: var(--gray);
    font-size: 3rem;
}

.logo-placeholder p {
    font-size: 1rem;
    margin-top: 10px;
}

/* Buttons */
.form-actions {
    padding: 20px 0 10px;
    text-align: right;
}

.btn-primary-modern {
    background: var(--primary);
    color: white;
    border: none;
    padding: 10px 24px;
    border-radius: 8px;
    font-weight: 500;
    transition: var(--transition);
    box-shadow: 0 4px 10px rgba(67, 97, 238, 0.3);
}

.btn-primary-modern:hover {
    background: var(--secondary);
    transform: translateY(-2px);
    box-shadow: 0 6px 15px rgba(67, 97, 238, 0.4);
}

.btn-secondary-modern {
    background: white;
    color: var(--dark);
    border: 1px solid var(--border);
    padding: 10px 24px;
    border-radius: 8px;
    font-weight: 500;
    transition: var(--transition);
    margin-left: 10px;
}

.btn-secondary-modern:hover {
    background: var(--light);
}

/* Server Info */
.server-info-list {
    padding: 0;
}

.info-item {
    display: flex;
    align-items: center;
    padding: 15px 0;
    border-bottom: 1px solid var(--border);
}

.info-item:last-child {
    border-bottom: none;
}

.info-icon {
    width: 40px;
    height: 40px;
    border-radius: 8px;
    background: var(--light);
    display: flex;
    align-items: center;
    justify-content: center;
    margin-right: 15px;
    color: var(--primary);
    font-size: 1.2rem;
}

.info-content h6 {
    margin: 0;
    font-weight: 600;
    color: var(--dark);
    font-size: 0.95rem;
}

.info-content p {
    margin: 5px 0 0;
    color: var(--gray);
    font-size: 0.9rem;
}

/* Stats */
.stats-grid {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 15px;
}

.stat-box {
    display: flex;
    align-items: center;
    padding: 15px;
    background: var(--light);
    border-radius: 8px;
}

.stat-icon {
    width: 45px;
    height: 45px;
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-right: 15px;
    color: white;
    font-size: 1.2rem;
}

.stat-primary { background: var(--primary); }
.stat-success { background: var(--success); }
.stat-info { background: var(--info); }
.stat-warning { background: var(--warning); }

.stat-info h3 {
    margin: 0;
    font-weight: 700;
    font-size: 1.5rem;
}

.stat-info p {
    margin: 5px 0 0;
    color: var(--gray);
    font-size: 0.85rem;
}

/* Alert */
.alert-modern {
    border-radius: 8px;
    border: none;
    box-shadow: var(--card-shadow);
    padding: 15px 20px;
    margin-bottom: 20px;
}

/* Responsive */
@media (max-width: 768px) {
    .stats-grid {
        grid-template-columns: 1fr;
    }
    
    .form-actions {
        text-align: center;
    }
    
    .btn-secondary-modern {
        margin-left: 0;
        margin-top: 10px;
    }
}
</style>

<script>
// File upload name display
document.getElementById('logoUpload').addEventListener('change', function(e) {
    var fileName = e.target.files[0].name;
    document.getElementById('fileName').textContent = fileName;
});

// Auto-hide alerts after 5 seconds
setTimeout(() => {
    const alerts = document.querySelectorAll('.alert');
    alerts.forEach(alert => {
        const bsAlert = new bootstrap.Alert(alert);
        bsAlert.close();
    });
}, 5000);
</script>

<?php include('./constant/layout/footer.php'); ?>