<?php
include('./constant/layout/head.php');
include('./constant/layout/header.php');
include('./constant/layout/sidebar.php');
include('./constant/connect.php');

// Get order ID from URL
$order_id = isset($_GET['id']) ? intval($_GET['id']) : 0;

if (!$order_id) {
    echo "<script>alert('Invalid invoice ID!'); window.history.back();</script>";
    exit();
}

// Fetch company information
$companySql = "SELECT * FROM system_settings WHERE id = 1";
$companyResult = $connect->query($companySql);
$company = $companyResult->fetch_assoc();

// Fetch order details
$orderSql = "SELECT * FROM wholesale_orders WHERE id = ? AND delete_status = 0";
$orderStmt = $connect->prepare($orderSql);
$orderStmt->bind_param("i", $order_id);
$orderStmt->execute();
$orderResult = $orderStmt->get_result();
$order = $orderResult->fetch_assoc();

if (!$order) {
    echo "<script>alert('Invoice not found!'); window.history.back();</script>";
    exit();
}

// Fetch order items
$itemsSql = "SELECT oi.*, p.product_name, p.hsn_code, p.unit 
             FROM wholesale_order_items oi 
             LEFT JOIN product p ON oi.product_id = p.product_id 
             WHERE oi.wholesale_order_id = ?";
$itemsStmt = $connect->prepare($itemsSql);
$itemsStmt->bind_param("i", $order_id);
$itemsStmt->execute();
$itemsResult = $itemsStmt->get_result();
$order_items = $itemsResult->fetch_all(MYSQLI_ASSOC);

// Calculate totals
$total_quantity = 0;
$total_taxable_value = 0;

foreach ($order_items as $item) {
    $total_quantity += $item['quantity'];
    $item_total = $item['quantity'] * $item['unit_price'];
    $discount_amount = ($item_total * $item['discount_percentage']) / 100;
    $total_taxable_value += ($item_total - $discount_amount);
}

// Payment status text
$payment_statuses = [
    1 => 'Full Payment',
    2 => 'Advance Payment', 
    3 => 'Part Payment',
    4 => 'No Payment'
];

$payment_types = [
    1 => 'Cash',
    2 => 'Cheque',
    3 => 'Credit Card',
    4 => 'Phone Pe',
    5 => 'Google Pay',
    6 => 'Amazon Pay',
    7 => 'Bank Transfer'
];
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <title>Invoice <?php echo $order['invoice_no']; ?></title>
    <style>
        .invoice-container {
            background: #fff;
            padding: 30px;
            border: 1px solid #ddd;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
            max-width: 800px;
            margin: 20px auto;
        }
        .invoice-header {
            border-bottom: 2px solid #333;
            padding-bottom: 20px;
            margin-bottom: 30px;
        }
        .company-info h2 {
            color: #333;
            margin: 0;
        }
        .invoice-title {
            text-align: center;
            background: #333;
            color: white;
            padding: 10px;
            margin: 20px 0;
        }
        .invoice-details {
            margin: 20px 0;
        }
        .table-invoice {
            width: 100%;
            border-collapse: collapse;
            margin: 20px 0;
        }
        .table-invoice th {
            background: #f8f9fa;
            border: 1px solid #ddd;
            padding: 12px;
            text-align: left;
            font-weight: bold;
        }
        .table-invoice td {
            border: 1px solid #ddd;
            padding: 12px;
        }
        .text-right {
            text-align: right;
        }
        .text-center {
            text-align: center;
        }
        .summary-table {
            width: 50%;
            margin-left: auto;
        }
        .summary-table td {
            padding: 8px;
            border: 1px solid #ddd;
        }
        .summary-table .total-row {
            background: #f8f9fa;
            font-weight: bold;
        }
        .footer {
            margin-top: 50px;
            padding-top: 20px;
            border-top: 1px solid #ddd;
        }
        .signature {
            margin-top: 80px;
        }
        .status-badge {
            padding: 5px 10px;
            border-radius: 3px;
            font-size: 12px;
            font-weight: bold;
        }
        .badge-paid { background: #28a745; color: white; }
        .badge-pending { background: #ffc107; color: black; }
        .badge-due { background: #dc3545; color: white; }
        .print-only { display: none; }
        @media print {
            .no-print { display: none; }
            .print-only { display: block; }
            .invoice-container {
                box-shadow: none;
                border: none;
                padding: 0;
            }
            body {
                background: white !important;
            }
        }
    </style>
</head>
<body>
    <div class="page-wrapper">
        <div class="container-fluid">
            <!-- Action Buttons -->
            <div class="row no-print">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            <div class="btn-group">
                                <button onclick="window.print()" class="btn btn-primary">
                                    <i class="fa fa-print"></i> Print Invoice
                                </button>
                                <a href="edit_wholesale_order.php?id=<?php echo $order_id; ?>" class="btn btn-warning">
                                    <i class="fa fa-edit"></i> Edit Invoice
                                </a>
                                <a href="view-wholesale-orders.php" class="btn btn-secondary">
                                    <i class="fa fa-arrow-left"></i> Back to List
                                </a>
                                <button onclick="downloadPDF()" class="btn btn-danger">
                                    <i class="fa fa-file-pdf-o"></i> Download PDF
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Invoice Content -->
            <div class="invoice-container">
                <!-- Header -->
                <div class="invoice-header">
                    <div class="row">
                        <div class="col-6 company-info">
                            <h2><?php echo htmlspecialchars($company['company'] ?? 'Pharmacy Company'); ?></h2>
                            <p><?php echo htmlspecialchars($company['system_name'] ?? 'Pharmacy System'); ?></p>
                            <p><?php echo htmlspecialchars($company['address'] ?? 'Company Address'); ?></p>
                            <p>Phone: <?php echo htmlspecialchars($company['phone'] ?? 'N/A'); ?></p>
                            <p>Email: <?php echo htmlspecialchars($company['email'] ?? 'N/A'); ?></p>
                            <?php if($company['logo']): ?>
                                <img src="<?php echo $company['logo']; ?>" alt="Company Logo" style="max-height: 80px;">
                            <?php endif; ?>
                        </div>
                        <div class="col-6 text-right">
                            <h1>WHOLESALE INVOICE</h1>
                            <p class="lead">Invoice No: <strong><?php echo $order['invoice_no']; ?></strong></p>
                            <p>Date: <?php echo date('d/m/Y', strtotime($order['invoice_date'])); ?></p>
                            <p>Time: <?php echo date('h:i A', strtotime($order['created_at'])); ?></p>
                            <span class="status-badge <?php echo $order['due_amount'] == 0 ? 'badge-paid' : 'badge-due'; ?>">
                                <?php echo $order['due_amount'] == 0 ? 'PAID' : 'DUE'; ?>
                            </span>
                        </div>
                    </div>
                </div>

                <!-- Vendor Information -->
                <div class="row invoice-details">
                    <div class="col-6">
                        <h4>Vendor Details:</h4>
                        <p><strong>Name:</strong> <?php echo htmlspecialchars($order['vendor_name']); ?></p>
                        <p><strong>Contact:</strong> <?php echo htmlspecialchars($order['vendor_contact']); ?></p>
                        <?php if($order['vendor_gstn']): ?>
                            <p><strong>GSTIN:</strong> <?php echo htmlspecialchars($order['vendor_gstn']); ?></p>
                        <?php endif; ?>
                    </div>
                    <div class="col-6 text-right">
                        <h4>Invoice Summary:</h4>
                        <p><strong>Payment Status:</strong> <?php echo $payment_statuses[$order['payment_status']]; ?></p>
                        <p><strong>Payment Method:</strong> <?php echo $payment_types[$order['payment_type']]; ?></p>
                        <p><strong>Total Items:</strong> <?php echo count($order_items); ?></p>
                        <p><strong>Total Quantity:</strong> <?php echo $total_quantity; ?></p>
                    </div>
                </div>

                <!-- Products Table -->
                <div class="invoice-title">
                    <h3>PRODUCT DETAILS</h3>
                </div>
                
                <table class="table-invoice">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Product Name</th>
                          
                            <th>Unit</th>
                            <th>Quantity</th>
                            <th>Rate (₹)</th>
                            <th>Discount %</th>
                            <th>Taxable Value (₹)</th>
                            <th>SGST %</th>
                            <th>CGST %</th>
                            <th>Total (₹)</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php 
                        $counter = 1;
                        $grand_total = 0;
                        foreach ($order_items as $item): 
                            $item_total = $item['quantity'] * $item['unit_price'];
                            $discount_amount = ($item_total * $item['discount_percentage']) / 100;
                            $taxable_value = $item_total - $discount_amount;
                            $sgst_amount = ($taxable_value * $item['sgst_percentage']) / 100;
                            $cgst_amount = ($taxable_value * $item['cgst_percentage']) / 100;
                            $item_final_total = $taxable_value + $sgst_amount + $cgst_amount;
                            $grand_total += $item_final_total;
                        ?>
                            <tr>
                                <td class="text-center"><?php echo $counter++; ?></td>
                                <td><?php echo htmlspecialchars($item['product_name']); ?></td>
                               
                                <td class="text-center"><?php echo $item['unit'] ?? 'PCS'; ?></td>
                                <td class="text-center"><?php echo $item['quantity']; ?></td>
                                <td class="text-right"><?php echo number_format($item['unit_price'], 2); ?></td>
                                <td class="text-center"><?php echo number_format($item['discount_percentage'], 2); ?>%</td>
                                <td class="text-right"><?php echo number_format($taxable_value, 2); ?></td>
                                <td class="text-center"><?php echo number_format($item['sgst_percentage'], 2); ?>%</td>
                                <td class="text-center"><?php echo number_format($item['cgst_percentage'], 2); ?>%</td>
                                <td class="text-right"><?php echo number_format($item_final_total, 2); ?></td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>

                <!-- Summary Section -->
                <div class="row">
                    <div class="col-6">
                        <h4>Terms & Conditions:</h4>
                        <ul>
                            <li>Goods once sold will not be taken back</li>
                            <li>Payment due within 30 days from invoice date</li>
                            <li>Subject to <?php echo htmlspecialchars($company['company'] ?? 'Our'); ?> jurisdiction</li>
                            <li>E. &. O.E.</li>
                        </ul>
                        
                        <?php if($order['is_edited']): ?>
                            <div class="alert alert-warning">
                                <strong>Note:</strong> This invoice was edited on 
                                <?php echo date('d/m/Y h:i A', strtotime($order['updated_at'])); ?>
                                <?php if($order['edit_reason']): ?>
                                    <br><strong>Reason:</strong> <?php echo htmlspecialchars($order['edit_reason']); ?>
                                <?php endif; ?>
                            </div>
                        <?php endif; ?>
                    </div>
                    <div class="col-6">
                        <table class="summary-table">
                            <tr>
                                <td><strong>Sub Total:</strong></td>
                                <td class="text-right">₹<?php echo number_format($order['sub_total'], 2); ?></td>
                            </tr>
                            <tr>
                                <td><strong>Total SGST:</strong></td>
                                <td class="text-right">₹<?php echo number_format($order['sgst_total'], 2); ?></td>
                            </tr>
                            <tr>
                                <td><strong>Total CGST:</strong></td>
                                <td class="text-right">₹<?php echo number_format($order['cgst_total'], 2); ?></td>
                            </tr>
                            <tr>
                                <td><strong>Total Amount:</strong></td>
                                <td class="text-right">₹<?php echo number_format($order['total_amount'], 2); ?></td>
                            </tr>
                            <?php if($order['discount_percentage'] > 0): ?>
                            <tr>
                                <td><strong>Discount (<?php echo number_format($order['discount_percentage'], 2); ?>%):</strong></td>
                                <td class="text-right">-₹<?php echo number_format(($order['total_amount'] * $order['discount_percentage']) / 100, 2); ?></td>
                            </tr>
                            <?php endif; ?>
                            <tr class="total-row">
                                <td><strong>GRAND TOTAL:</strong></td>
                                <td class="text-right">₹<?php echo number_format($order['grand_total'], 2); ?></td>
                            </tr>
                            <tr>
                                <td><strong>Paid Amount:</strong></td>
                                <td class="text-right">₹<?php echo number_format($order['paid_amount'], 2); ?></td>
                            </tr>
                            <tr class="<?php echo $order['due_amount'] > 0 ? 'text-danger' : 'text-success'; ?>">
                                <td><strong>Due Amount:</strong></td>
                                <td class="text-right"><strong>₹<?php echo number_format($order['due_amount'], 2); ?></strong></td>
                            </tr>
                        </table>
                    </div>
                </div>

                <!-- Footer -->
                <div class="footer">
                    <div class="row">
                        <div class="col-4 text-center signature">
                            <p>_________________________</p>
                            <p><strong>Vendor Signature</strong></p>
                        </div>
                        <div class="col-4 text-center signature">
                            <p>_________________________</p>
                            <p><strong>Authorized Signatory</strong></p>
                        </div>
                        <div class="col-4 text-center">
                            <p class="print-only">Generated on: <?php echo date('d/m/Y h:i A'); ?></p>
                            <p><strong><?php echo htmlspecialchars($company['company'] ?? 'Pharmacy Company'); ?></strong></p>
                            <p>Thank you for your business!</p>
                        </div>
                    </div>
                </div>

                <!-- Tax Calculation Details (Optional) -->
                <div class="print-only" style="margin-top: 30px; font-size: 12px;">
                    <h5>Tax Calculation Details:</h5>
                    <table class="table-invoice">
                        <thead>
                            <tr>
                                <th>HSN Code</th>
                                <th>Taxable Value</th>
                                <th>SGST Rate</th>
                                <th>SGST Amount</th>
                                <th>CGST Rate</th>
                                <th>CGST Amount</th>
                                <th>Total Tax</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $tax_summary = [];
                            foreach ($order_items as $item) {
                                $hsn = $item['hsn_code'] ?? 'N/A';
                                $item_total = $item['quantity'] * $item['unit_price'];
                                $discount_amount = ($item_total * $item['discount_percentage']) / 100;
                                $taxable_value = $item_total - $discount_amount;
                                $sgst_amount = ($taxable_value * $item['sgst_percentage']) / 100;
                                $cgst_amount = ($taxable_value * $item['cgst_percentage']) / 100;
                                
                                if (!isset($tax_summary[$hsn])) {
                                    $tax_summary[$hsn] = [
                                        'taxable_value' => 0,
                                        'sgst_rate' => $item['sgst_percentage'],
                                        'sgst_amount' => 0,
                                        'cgst_rate' => $item['cgst_percentage'],
                                        'cgst_amount' => 0
                                    ];
                                }
                                
                                $tax_summary[$hsn]['taxable_value'] += $taxable_value;
                                $tax_summary[$hsn]['sgst_amount'] += $sgst_amount;
                                $tax_summary[$hsn]['cgst_amount'] += $cgst_amount;
                            }
                            
                            foreach ($tax_summary as $hsn => $tax): 
                            ?>
                                <tr>
                                    <td class="text-center"><?php echo $hsn; ?></td>
                                    <td class="text-right">₹<?php echo number_format($tax['taxable_value'], 2); ?></td>
                                    <td class="text-center"><?php echo number_format($tax['sgst_rate'], 2); ?>%</td>
                                    <td class="text-right">₹<?php echo number_format($tax['sgst_amount'], 2); ?></td>
                                    <td class="text-center"><?php echo number_format($tax['cgst_rate'], 2); ?>%</td>
                                    <td class="text-right">₹<?php echo number_format($tax['cgst_amount'], 2); ?></td>
                                    <td class="text-right">₹<?php echo number_format($tax['sgst_amount'] + $tax['cgst_amount'], 2); ?></td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <script>
    function downloadPDF() {
        alert('PDF download functionality would be implemented here. For now, please use Print function and save as PDF.');
        // In a real implementation, you would use a PDF generation library
        // window.location.href = 'generate_pdf.php?id=<?php echo $order_id; ?>';
    }

    // Auto-print if print parameter is set
    <?php if(isset($_GET['print']) && $_GET['print'] == '1'): ?>
        window.onload = function() {
            window.print();
        }
    <?php endif; ?>

    // Keyboard shortcuts
    document.addEventListener('keydown', function(e) {
        // Ctrl+P for print
        if (e.ctrlKey && e.key === 'p') {
            e.preventDefault();
            window.print();
        }
        // Esc to go back
        if (e.key === 'Escape') {
            window.history.back();
        }
    });
    </script>

    <!-- Include jQuery Print -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jQuery.print/1.6.2/jQuery.print.min.js"></script>

</body>
</html>

<?php include('./constant/layout/footer.php'); ?>